#!/usr/local/bin/perl
# 
# $Header: listModules.pl 23-dec-2005.11:41:14 jsmoler Exp $
#
# OC4J_listModules.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      OC4J_listModules.pl - OC4J ECM integration: list modules
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of modules
#      for an OC4J instance. For each module, includes the parent application
#      name, module name, and module type (see listOC4JModules in asecm.pm).
#
#      Implements the ModuleList metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <version category>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/02/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

my @modules = listOC4JModules($instanceName, $versionCategory);

for my $moduleRef (@modules)
{
    printResult(
        $$moduleRef{'appName'}, 'string',
        $$moduleRef{'name'}, 'string',
        $$moduleRef{'type'}, 'string',
    );
}
