#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/OHS_getCipherSuites.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# OHS_getCipherSuites.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OHS_getCipherSuites.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider OHS instance id for AS11
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     03/11/05 - jsmoler_ecm_050228
#    jsmoler     02/28/05 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

my $hash = parseApacheConf();
my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $props = $$vhost{'properties'};
    if ($props)
    {
        my $ssl = peek($$props{'SSLEngine'});
        if (defined($ssl) && ($ssl eq 'on'))
        {
            my $cipherSuite = peek($$props{'SSLCipherSuite'});
            printResult(
                $addr,        'string',
                $cipherSuite, 'string(2000)',
            );
        }
    }
}
