#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_getCaches.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_getCaches.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getCaches.pl - WebCache ECM integration: list cluster members
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of names
#      of caches that are peers of the cache for the machine.
#
#      Implements the Caches metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     01/26/05 - check for singleton cluster
#    jsmoler     11/12/04 - output host name and Oracle Home instead of cache name
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use Net::hostent;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $xmlFile = getWebCacheXml($wcId);
exit if (!defined($xmlFile));

my @caches = simpleXPathQuery($xmlFile,
                              'CALYPSO/CACHE');

if (@caches > 1)
{
    for my $cache (@caches)
    {    
        my $hostName = $$cache{'HOSTNAME'};
        my $hostEnt = gethostbyname($hostName);
        $hostName = $hostEnt->name;
        printResult(
            $hostName,            'raw-string',
            $$cache{'ORACLEHOME'},'raw-string',
            $$cache{'CAPACITY'},  'number',
        );
    }
}
