#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_getHostMappings.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_getHostMappings.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getHostMappings.pl - WebCache ECM integration: get host mappings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of mappings from
#      site to host.
#
#      Implements the HostMappings metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $xmlFile = getWebCacheXml($wcId);
exit if (!defined($xmlFile));

my @mappings = simpleXPathQuery($xmlFile,
                                'CALYPSO/GENERAL/VIRTUALHOSTMAP');

for my $mapping (@mappings)
{
    my $siteName = ensuredef($$mapping{'NAME'});
    my $sitePort = ensuredef($$mapping{'PORT'});
    my $siteURL = ensureSlash($$mapping{'URL'});

    my @hostrefs = simpleXPathQuery($xmlFile,
                                    'CALYPSO/GENERAL/VIRTUALHOSTMAP[@NAME="' . $siteName . '"][@PORT="' . $sitePort . '"]/HOSTREF');
    for my $hostref (@hostrefs)
    {
        my $hostID = $$hostref{'HOSTID'};
        
        my $host = (simpleXPathQuery($xmlFile,
                                     'CALYPSO/GENERAL/HOST[@ID="' . $hostID . '"]'))[0];
        
        printResult(
            $siteName,              'string',
            $sitePort,              'string',
            $siteURL,               'string',
            $$host{'NAME'},         'string',
            $$host{'PORT'},         'number',
        );
    }
}
