#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_getListenPorts.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_getListenPorts.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getListenPorts.pl - WebCache ECM integration: get listening ports
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of listening
#      ports.
#
#      Implements the ListenPorts metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     10/07/04 - change SSL mode to protocol
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/20/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $cacheName = getMyCache($hostName, $wcId);
my $xmlFile = getWebCacheXml($wcId);
exit if (!defined($xmlFile));

my @results = simpleXPathQuery($xmlFile,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/MULTIPORT/LISTEN[@PORTTYPE="NORM"]');

for my $result (@results)
{
    my $ip = getListenIP($$result{'IPADDR'});
    my $protocol = getListenProtocol($$result{'SSLENABLED'});
    printResult(
        $ip,                'string',
        $$result{'PORT'},   'number',
        $protocol,          'string',
    );
}
