#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_getOriginServers.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_getOriginServers.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getOriginServers.pl - WebCache ECM integration: get origin servers
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of origin servers.
#
#      Implements the OriginServers metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     01/10/05 - use getListenProtocol 
#    jsmoler     12/23/04 - jsmoler_ecm_041213
#    jsmoler     12/16/04 - make protocol lowercase 
#    jsmoler     10/14/04 - jsmoler_ecm_041013a
#    jsmoler     10/07/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $xmlFile = getWebCacheXml($wcId);
exit if (!defined($xmlFile));

my @hosts = simpleXPathQuery($xmlFile,
                             'CALYPSO/GENERAL/HOST');

for my $host (@hosts)
{
    my $protocol = getListenProtocol($$host{'SSLENABLED'});
    printResult(
        $$host{'NAME'},         'string',
        $$host{'PORT'},         'number',
        $protocol,              'string',
        $$host{'LOADLIMIT'},    'number',
    );
}
