#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_getPerformanceRelated.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_getPerformanceRelated.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getPerformanceRelated.pl - WebCache ECM integration: get performance-
#                                          related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve performance-related
#      configuration information for a cache.
#
#      Implements the PerformanceRelated metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     10/15/04 - fix typo
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $cacheName = getMyCache($hostName, $wcId);

my $xmlFile = getWebCacheXml($wcId);
exit if (!defined($xmlFile));

my $limits = (simpleXPathQuery($xmlFile,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/RESOURCELIMITS'))[0];

my $info = (simpleXPathQuery($xmlFile,
                             'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/CALYPSONETINFO'))[0];

printResult(
    $$limits{'MAXCACHESIZE_MB'},        'number',
    $$limits{'MAXINBOUNDCONNECTIONS'},  'number',
    $$info{'KEEPALIVE_TIMEOUT'},        'number',
    $$info{'OSRECV_TIMEOUT'},           'number',
);
