#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_getSiteAliases.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_getSiteAliases.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getSiteAliases.pl - WebCache ECM integration: get site aliases
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of site aliases.
#
#      Implements the SiteAliases metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     10/07/04 - 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $xmlFile = getWebCacheXml($wcId);

exit if (!defined($xmlFile));

my @sites = simpleXPathQuery($xmlFile,
                            'CALYPSO/GENERAL/SITE');

for my $site (@sites)
{
    my $siteName = ensuredef($$site{'NAME'});
    my $sitePort = ensuredef($$site{'PORT'});
    my $siteURL = ensureSlash($$site{'URL'});

    my @aliases = simpleXPathQuery($xmlFile,
                                   'CALYPSO/GENERAL/SITE[@NAME="' . $siteName . '"][@PORT="' . $sitePort . '"]/ALIAS');
    for my $alias (@aliases)
    {
        my $aliasURL = ensureSlash($$alias{'URL'});
        printResult(
            $siteName,          'string',
            $sitePort,          'number',
            $siteURL,           'string',
            $$alias{'NAME'},    'string',
            $$alias{'PORT'},    'number',
            $aliasURL,          'string',
        );
    }
}
