#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/WebCache_listConfigFiles.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# WebCache_listConfigFiles.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_listConfigFiles.pl - WebCache ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for WebCache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider webcache instance id for AS11
#    jsutton     03/30/10 - AS11 updates
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/19/04 - Creation
# 

use strict;
use ias::asecm;
use File::Spec;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[3];
}

my $webCacheXml = getWebCacheXml($wcId);
exit if (!defined($webCacheXml));

my $internalCfgXml = 'webcache/internal.xml';
my $webcacheCfgXml = 'webcache/webcache.xml';

if ($wcId ne "")
{
  # use AS11 directory structure
  $internalCfgXml = "config/WebCache/$wcId/internal.xml";
  $webcacheCfgXml = "config/WebCache/$wcId/webcache.xml";
}

my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];

statFiles(
    $forUpload,
    $targetName,
    $webcacheCfgXml,
    $internalCfgXml,
);
