#!/usr/local/bin/perl
#
# getBpelGeneralDetail.pl
#
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getBpelGeneralDetail.pl - BPEL PM ECM integration
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_integrationbpm.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    kotkumar    07/27/07 - Updating for BPEL 10.1.2.
#    rsaraswa    05/20/07 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $oracleHome = $ARGV[0];
my $path;
my $xmlFile;

if(-e  "$oracleHome/bpel/system/config/collaxa-config.xml")
{
	$xmlFile = "$oracleHome/bpel/system/config/collaxa-config.xml";
}else {
	$xmlFile = "$oracleHome/integration/orabpel/system/config/collaxa-config.xml";
}
my $soapServerUrl = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="soapServerUrl"]/value'))[0];
my $soapCallbackUrl = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="soapCallbackUrl"]/value'))[0];
my $datasourceJndi = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="datasourceJndi"]/value'))[0];
my $txDatasourceJndi = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="txDatasourceJndi"]/value'))[0];


ias::asecm::printResult(
     $soapServerUrl,      'string',
     $soapCallbackUrl,    'string',
     $datasourceJndi,   'string',
     $txDatasourceJndi,   'string',
);




