#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ias/DcmAutoArchiveCheck.pl /main/2 2009/09/10 14:00:01 jsmoler Exp $
#
# DcmAutoArchiveCheck.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      DcmAutoArchiveCheck.pl - IAS FMW integration: get resuls of dcmctl command.
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve the output from the
#      "$oracleHome/dcm/bin/dcmctl set" command
#
#      Implements the DcmAutoArchiveCheck metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       jsmoler  09/10/09 - check if dcmctl exists
#    jjustiso/jsmoler     05/28/09 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

if (! -e "$oracleHome/dcm/bin/dcmctl")
{
    exit;
}
my @results = split(/\n/, `$oracleHome/dcm/bin/dcmctl set`);
for my $line (@results)
{
   if ($line =~ /Auto Archive Count\s*:\s*(.+)/)
   {
       my $value = $1;
       printResult($value,  'string');
       last;
   }
}
