#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ias/DebugLogLevelCheck.pl /main/2 2010/04/15 07:04:17 aghanti Exp $
#
# DebugLogLevelCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      DebugLogLevelCheck.pl - IAS FMW integration: get OPMN-related configuration
#      information.
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve OPMN-related
#      information forelement  opmn/debug in opmn.xml file.
#
#      Implements the DebugLogLevelCheck metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  04/15/10 - XbranchMerge aghanti_bug-9557735 from
#                           st_emll_10.3.3
#       aghanti  04/14/10 - For AS11g, look for opmn.xml in a different
#                           location
#    jjustiso/jsmoler    05/28/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $xmlFile = "$oracleHome/opmn/conf/opmn.xml";

# Look for opmn.xml in a different location for 11g
if (!-e $xmlFile) {
  $xmlFile = "$oracleHome/config/OPMN/opmn/opmn.xml";
}

if (-e $xmlFile)
{

  my $debugLog = (simpleXPathQuery($xmlFile,'opmn/debug'))[0];

  printResult(
    
      $$debugLog{'comp'},          'string',
      $$debugLog{'rotation-size'},  'string',
  );


}
