#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ias/LogLevelCheck.pl /main/1 2009/06/26 15:55:37 jsmoler Exp $
#
# LogLevelCheck.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#       LogLevelCheck.pl - IAS FMW integration: get OPMN-related information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve OPMN-related 
#      information on element - notification-server/ log-file attributes
#      and /process-manager/log-file from the opmn.xml file.
#
#      Implements the LogLevelCheck metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jjustiso/jsmoler     05/28/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $xmlFile = "$oracleHome/opmn/conf/opmn.xml";

if (-e $xmlFile)
{

  my $nsLog = (simpleXPathQuery($xmlFile, 'opmn/notification-server/log-file'))[0];
  my $pmLog = (simpleXPathQuery($xmlFile, 'opmn/process-manager/log-file'))[0];

  printResult(
      'notification-server',       'string',
      $$nsLog{'level'},          'string',
      $$nsLog{'rotation-size'},  'string',
  );

  printResult(
      
     'process-manager',       'string',
      $$pmLog{'level'},          'string',
      $$pmLog{'rotation-size'},  'string',
  );


}
