#!/usr/local/bin/perl
# 
# $Header: jserv_assoc.pl 26-jul-2007.07:11:04 jsutton Exp $
#
# jserv_assoc.pl
# 
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      jserv_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     07/26/07 - Pick up existing shared OH work
#    jsutton     07/25/07 - Shared home work
#    jsutton     11/07/05 - Fix up requires and directory paths 
#    jsutton     10/13/05 - Fix hardcoded refs to liveLink 
#    jsutton     10/07/05 - apache target name should be in proper position 
#    jsutton     09/27/05 - jsutton_jserv_cfg_mtrx
#    jsutton     09/23/05 - Creation
# 

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;

#******************************************
#     Global Variables
#*****************************************
my $result = ();
#
# as new relationships are exposed, add them here
#
my @ias_assoc_results;

my $oracleHome = shift;
my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";

# use targets.xml to find ias, apache instances; associate jserv with Apache
#
if (-e $discoveredTargetsFile)
{
  my $iasName;
  my @iasTargets = simpleXPathQuery($discoveredTargetsFile, 'Targets/Target[@TYPE="oracle_ias"]');
  for my $iast (@iasTargets)
  {
    $iasName = $$iast{'NAME'};
  }
  my $iasHost;
  $iasHost = substr($iasName,index($iasName,".")+1);
  my @allTargets = simpleXPathQuery($discoveredTargetsFile, 'Targets/Target[@TYPE="oracle_apache"]');
  my ($apacheName);
  for my $target (@allTargets)
  {
    if ($$target{'TYPE'} eq 'oracle_apache')
    {
      print "em_result=$ecmAssoc::CONNECTS_TO|$$target{'NAME'}|$ecmAssoc::ORACLE_APACHE_TYPE|\n";
    }
  }
}

1;
# End of the Program
