#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/oc4j/LogGrowthCheck.pl /main/1 2009/06/26 15:55:37 jsmoler Exp $
#
# LogGrowthCheck.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LogGrowthCheck.pl - OC4J ECM integration: get application configuration
#                           information
#
#    DESCRIPTION
#      Implements the LogGrowthCheck metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     05/27/09 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

my %moduleData = ias::asecm::getOpmnModuleData({
    'process-type' => $instanceName,
    'module' => 'OC4J'
});

my $javaOptions = $moduleData{'start-parameters'}{'java-options'};
my $oc4jOptions = $moduleData{'start-parameters'}{'oc4j-options'};

printResult(
    $javaOptions, 'string(2000)',
    $oc4jOptions, 'string(2000)',
);
