#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/oc4j/getAppRoutingIds.pl /main/1 2009/06/09 13:51:42 jsmoler Exp $
#
# getAppRoutingIds.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getAppRoutingIds.pl - Gets the routing ID specified for the
#        OC4J in opmn.xml.
#
#    DESCRIPTION
#      Command-line utility called by the agent to retrieve the
#      routing IDs for the applications deployed to the OC4J.  These
#      routing IDs are defined in server.xml and opmn.xml.
#
#      Command-line arguments: <oracle home> <oc4j instance name> <version category>
#
#      Outputs the value of each application's routing id.  Output format is:
#        em_result={application}|{routing-id}
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/12/07 - support OPMN variables
#    echolank    01/19/06 - support OC4J group routing IDs
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    echolank    12/07/05 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

# get default routing ID for the OC4J.  This is typically passed in by
# OPMN.
my %moduleData = ias::asecm::getOpmnModuleData({
    'module' => 'OC4J',
    'process-type' => $instanceName
});
my $oc4jRoutingId = $moduleData{'start-parameters'}{'routing-id'};
if (!defined($oc4jRoutingId))
{
    # OPMN does not specify a routing ID for either the OC4J or
    # the ias instance. so, default routing id is "global"
    $oc4jRoutingId = 'global';
}

# look in server.xml and get application specific routing IDs
my @results = listOC4JAppInfo($instanceName, $versionCategory);
for my $resultRef (@results)
{
    my $name = $$resultRef{'name'};
    my $routingId = $$resultRef{'routing-id'};
    if (!defined($routingId))
    {
        # default unspecified routing ID to the routing ID determined earlier
        $routingId = $oc4jRoutingId;
    }
    printResult(
        $name,      'string',
        $routingId, 'string'
    );
}
