#!/usr/local/bin/perl
# 
# $Header: getConnectionPools.pl 22-dec-2005.17:23:09 jsmoler Exp $
#
# getConnectionPools.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      getConnectionPools.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     11/29/05 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];


my @dataSourceFiles = listOC4JDataSourceFiles($instanceName);
for my $appInfo (@dataSourceFiles)
{
    my @connectionPools = simpleXPathQueryForNodes(
        $$appInfo{'file'},
        'data-sources/connection-pool'
    );
    for my $connectionPool (@connectionPools)
    {
        my $factoryAttrs;
        for my $childNode (@{$$connectionPool{'children'}})
        {
            if ($$childNode{'tagName'} eq 'connection-factory')
            {
                $factoryAttrs = $$childNode{'attributes'};
                last;
            }
        }
        
        my $poolAttrs = $$connectionPool{'attributes'};
        
        printResult(
            $$poolAttrs{'name'},                            'string',
            $$appInfo{'application'},                       'string',
            $$factoryAttrs{'factory-class'},                'string',
            $$factoryAttrs{'url'},                          'string',
            $$poolAttrs{'max-connections'},                 'number',
            $$poolAttrs{'min-connections'},                 'number',
            $$poolAttrs{'used-connection-wait-timeout'},    'number',
            $$poolAttrs{'inactivity-timeout'},              'number',
        );
    }
}
