#!/usr/local/bin/perl
#
# $Header: emll/sysman/admin/scripts/ias/oc4j/getJVMData.pm /main/2 2010/07/07 22:09:29 ckalivar Exp $
#
# getJVMData.pm
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getJVMData.pm - <gets oc4jjvm java information modules>
#
#    DESCRIPTION
#       moved methods from getJVMInfo.pl to here for modularity
#       EXPORT
#          getJVMVersion
#          isJVMMBeansEnabledOn1013PlusOC4J
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       ckalivar 06/30/10 - Creation
#

package ias::oc4j::getJVMData;
use strict;
require "emd_common.pl";
use ias::asecm;
use ias::simpleXPath;
use Exporter 'import';

our @EXPORT = qw(
    getJVMVersion
    isJVMMBeansEnabledOn1013PlusOC4J
);




sub getJVMVersion
{
  my ($oracleHome,$instanceName) = @_;
  my $jdkLocation = getJDKLocationForOC4J($oracleHome,$instanceName);
  my $jdkVersion = "1.5.0_05";

#
# Check by doing java -version and extract version of jvm
#
  my $verOut = `$jdkLocation -version 2>&1`;
  if ($? != 0)
  {
    main::EMD_PERL_DEBUG("Failed to run $jdkLocation -version command\n");
  }
  else
  {
    main::EMD_PERL_DEBUG("Output of $jdkLocation -version command is $verOut\n");
    my @array = split (/\r/,$verOut);
    my $verString;
    VERLINE:foreach $verString (@array) {
      if (index($verString,"version") >= 0)
      {
         $verString =~ s/^\s+//;   # remove any leading space
         chomp($verString);
         $verString = substr($verString,index($verString,"\""));
         my $firstIndex = index($verString,"\"");
         my $secIndex = index($verString,"\"",$firstIndex+1);
         $verString = substr($verString, $firstIndex+1, $secIndex-1);
         $jdkVersion = $verString;
         my $indexOfUnderscore = index($verString,"_");
         if ($indexOfUnderscore > 0)
         {
            $jdkVersion = substr($verString,0,$indexOfUnderscore);
         }
         main::EMD_PERL_DEBUG ("Setting jdk version to $jdkVersion\n");
         last VERLINE;
      }
    }
  }
  return $jdkVersion;
}

sub getJDKLocationForOC4J
{
   my ($iasHome, $oc4jInstanceDisplayName) = @_;
   my $isEnabled = "0";
   main::EMD_PERL_DEBUG("JVM location for $oc4jInstanceDisplayName\n");

   my %moduleData = ias::asecm::getOpmnModuleData({
      'module' => 'OC4J',
      'process-type' => $oc4jInstanceDisplayName
   });
   my $javaLocation = $moduleData{'start-parameters'}{'java-bin'};
   if (!defined($javaLocation))
   {
      $javaLocation = "$iasHome/jdk/bin/java";
   }
   main::EMD_PERL_DEBUG("Returning java loc as $javaLocation\n");
   return $javaLocation;
}

sub isJVMMBeansEnabledOn1013PlusOC4J
{
  my ($iasHome, $oc4jInstanceDisplayName) = @_;
  my $isEnabled = "0";
  main::EMD_PERL_DEBUG("is JVMs enabled for $oc4jInstanceDisplayName\n");

   my %moduleData = ias::asecm::getOpmnModuleData({
      'module' => 'OC4J',
      'process-type' => $oc4jInstanceDisplayName
   });
   my $javaStartOptions = $moduleData{'start-parameters'}{'java-options'};
   if (defined($javaStartOptions) && index($javaStartOptions,"-Dcom.sun.management.jmxremote") >= 0)
   {
      $isEnabled = "1";
      main::EMD_PERL_DEBUG("JVM Mbeans enabled for $oc4jInstanceDisplayName\n");
   } else {
      main::EMD_PERL_DEBUG("NO JVM Mbeans enabled for $oc4jInstanceDisplayName\n");
   }
   return $isEnabled;
}


