#!/usr/local/bin/perl
# 
# $Header: getNativeDataSources.pl 22-dec-2005.17:23:11 jsmoler Exp $
#
# getNativeDataSources.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      getNativeDataSources.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     11/29/05 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];


my @dataSourceFiles = listOC4JDataSourceFiles($instanceName);
for my $appInfo (@dataSourceFiles)
{
    my @dataSources = simpleXPathQuery(
        $$appInfo{'file'},
        'data-sources/native-data-source'
    );
    my %jndiLocHash;
    for my $dataSource (@dataSources)
    {
        $jndiLocHash{$$dataSource{'jndi-name'}} = $dataSource;
    }
    for my $jndiLoc (keys %jndiLocHash)
    {
        my $dataSource = $jndiLocHash{$jndiLoc};
        printResult(
            $$dataSource{'name'},                   'string',
            $$appInfo{'application'},               'string',
            $$dataSource{'jndi-name'},              'string',
            $$dataSource{'data-source-class'},      'string',
            $$dataSource{'url'},                    'string',
        );
    }
}
