# $Header: emll/sysman/admin/scripts/ias/oc4j_assoc.pl /main/9 2012/10/03 15:57:41 fmorshed Exp $
#
# Package : oc4j_assoc.pl
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       oc4j_assoc.pl
#
#   DESCRIPTION
#       Returns information on targets associated with this oc4j instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      fmorshed   10/02/12 - Remove / as first character to query targets.xml
#      fmorshed   01/19/12 - In advent of central collector, change query of
#                 targets.xml to account for the new hierarchy of tags.
#      jsutton    07/26/07 - Pick up existing shared OH work
#      jsutton    07/25/07 - Shared home work
#      jsutton    11/08/05 - Get db assoc for this OC4J instance only
#      jsutton    11/07/05 - Fix up requires and directory paths 
#      jsutton    10/12/05 - Deal with TNS connect descriptors 
#      jsutton    10/07/05 - Another default data source connection to 
#                            discount 
#      ndutko     08/03/05 - ndutko_code_checkin
#      jsutton    07/18/05 - initial
##*************************************************************

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;

#******************************************
#     Global Variables
#*****************************************
      my $result = ();
#
# as new relationships are exposed, add them here
#
my @ias_assoc_results;

my $oracleHome = shift;
my $targetName = shift;

$ENV{EMDROOT} = $ENV{CCR_HOME};
require "$ENV{CCR_HOME}/sysman/admin/scripts/db/net/listenerUtil.pl";

my $iasConfigFile = $oracleHome . "/config/ias.properties";
my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";

getOc4jDbAssoc();

foreach $result (@ias_assoc_results)
{
  print $result;
}

sub getOc4jDbAssoc
{
  # use targets.xml to find ias, OC4J instances; look up data sources via
  # the OC4J instances' data-sources.xml files; pull out the URL & report
  if (-e $discoveredTargetsFile)
  {
    my $iasName;
    my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';
    my @iasTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix . '/Targets/Target[@TYPE="oracle_ias"]');
    for my $iast (@iasTargets)
    {
      $iasName = $$iast{'NAME'};
    }
    my $iasHost;
    $iasHost = substr($iasName,index($iasName,".")+1);

    my ($oc4jDataSourcesFile,$dbSpec);
    my $oc4jDataSourcesFile = $oracleHome."/j2ee/".$targetName."/config/data-sources.xml";
    if (-e $oc4jDataSourcesFile)
    {
      my @dsInfo = simpleXPathQuery($oc4jDataSourcesFile,"data-sources/data-source");
      for my $dsData (@dsInfo)
      {
        (undef,$dbSpec) = split(/@/,$$dsData{'url'});
        $dbSpec =~ s/\/\///g;
        $dbSpec =~ s/\//:/g;
        $dbSpec =~ s/localhost/$iasHost/g;
        if (index($dbSpec,"(ADDRESS=") >= 0)
        {
          # pick off host:port:sid or host:service_name sets in TNS descriptor
          # Host/Port info is in ADDRESS, Service Name/SID is in CONNECT_DATA
          my $addresses = getParamValueListFor($dbSpec,"ADDRESS");
          my $connectData = getParamValueListFor($dbSpec,"CONNECT_DATA");
          my $sidOrService = "";
          my ($addrInfo,$connInfo);
          foreach $addrInfo(@$addresses)
          {
            foreach $connInfo(@$connectData)
            {
              if (defined($connInfo->{SERVICE_NAME}))
              {
                $sidOrService = $connInfo->{SERVICE_NAME};
              }
              elsif (defined($connInfo->{SID}))
              {
                $sidOrService = $addrInfo->{PORT}.":".$connInfo->{SID};
              }
              push(@ias_assoc_results, "em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_DATABASE_TYPE|$addrInfo->{HOST}:$sidOrService\n");
            }
          }
        }
        elsif (index($dbSpec,"oracle.regress.rdbms.dev.us.oracle.com") < 0)
        {
          my ($dsHost,$dsPort,$dsSid) = split(":",$dbSpec);
          if (!($dsSid eq "oracle"))
          {
            push(@ias_assoc_results, "em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_DATABASE_TYPE|$dbSpec\n");
          }
        }
      }
    }
  }
}

1;
# End of the Program
