#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ohs/FilePermCheck.pl /main/4 2009/09/10 14:00:01 jsmoler Exp $
#
# FilePermCheck.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      FilePermCheck.pl - Apache FMW integration: get general configuration
#                             information
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve permissions
#      information for Apache ".apachectl". 
#
#      Implements the FilePermCheck metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       jsmoler  09/10/09 - check if files exist
#       jsutton  08/18/09 - exit vs. return
#       jsmoler  07/29/09 - map to user names
#    jjustiso/jsmoler     05/26/09 - Created
#   
# 

use strict;
use ias::asecm;
use File::stat ();

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# This health check is for Unix only
if (getPlatform() ne 'unix')
{
    exit;
}

printPermissions("$oracleHome");
printPermissions("$oracleHome/Apache/Apache/bin/.apachectl");

sub printPermissions
{
    my ( $path ) = @_;
    if (! -e $path)
    {
        return;
    }
    my $st = File::stat::stat($path);
    if (defined($st))
    {
        my ( $user ) = getpwuid($st->uid);
        my ( $group ) = getgrgid($st->gid);
        printResult($path, 'path',
                    $st->mode, 'string',
                    $user, 'string',
                    $group, 'string');
    }
}
