#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ohs/IdentityCheck.pl /main/4 2010/06/22 23:09:59 aghanti Exp $
#
# IdentityCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      IdentityCheck.pl - Apache : get general configuration information 
#                           for Group and User directives
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve general configuration
#      information for Apache. Collect Group and User directives from all OHS 
#      conf files.
#      Implements the FilePermCheckB metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  06/17/10 - Consider OHS instance id for AS11
#       jsutton  08/18/09 - exit vs. return
#       jsmoler  07/29/09 - map to user names
#    jjustiso/jsmoler     05/25/09  - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

# This health check is for Unix only
if (getPlatform() ne 'unix')
{
    exit;
}

my $hash = parseApacheConf();

printResult(
    '', 'string',
    getUserName(peek($$hash{'User'})), 'string',
    getGroupName(peek($$hash{'Group'})), 'string',
);

my $vhosts = $$hash{'VirtualHost'};
for my $vhostExpr (keys %{$vhosts})
{
    my $vhostHash = $$vhosts{$vhostExpr};
    printResult(
        $vhostExpr, 'string',
        getUserName(peek($$vhostHash{'User'})), 'string',
        getGroupName(peek($$vhostHash{'Group'})), 'string',
    );
}

sub getUserName
{
    my ( $user ) = @_;
    if (!defined($user))
    {
        return undef;
    }
    if ($user =~ /^\#(.+)/)
    {
        my $id = $1;
        ( $user ) = getpwuid($id);
    }
    return $user;
}
sub getGroupName
{
    my ( $group ) = @_;
    if (!defined($group))
    {
        return undef;
    }
    if ($group =~ /^\#(.+)/)
    {
        my $id = $1;
        ( $group ) = getgrgid($id);
    }
    return $group;
}
