#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ohs/LogGrowthCheck.pl /main/4 2010/06/22 23:09:59 aghanti Exp $
#
# LogGrowthCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LogGrowthCheck.pl - Apache FMW integration:get information on CustomLog
#                     ErrorLog, TransferLog directives in all OHS config files
#
#    DESCRIPTION
#      Command line utility called by the Agent to
#      get information on CustomLog, ErrorLog, TransferLog directives in all OHS 
#      config files
#      information for Apache.
#
#      Implements the LogGrowthCheck metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  06/17/10 - Consider OHS instance id for AS11
#       jsmoler  03/02/10 - fix 9438811
#       jsmoler  10/16/09 - fix bug 8939046
#    jjustiso/jsmoler     05/27/09 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

my $hash = parseApacheConf();

printResult1(
    ' ',
    'CustomLog',
    parseCustomLogArg(peek($$hash{'CustomLog'})),
);
printResult1(
    ' ',
    'ErrorLog',
    peek($$hash{'ErrorLog'}),
);
printResult1(
    ' ',
    'TransferLog',
    peek($$hash{'TransferLog'}),
);

my $vhosts = $$hash{'VirtualHost'};
for my $vhostExpr (keys %{$vhosts})
{
    my $vhostHash = $$vhosts{$vhostExpr};
    printResult1(
        $vhostExpr,
        'CustomLog',
        parseCustomLogArg(peek($$vhostHash{'CustomLog'})),
    );
    printResult1(
        $vhostExpr,
        'ErrorLog',
        peek($$vhostHash{'ErrorLog'}),
    );
    printResult1(
        $vhostExpr,
        'TransferLog',
        peek($$vhostHash{'TransferLog'}),
    );
}

#
# Find the first argument to the CustomLog directive (delineated by quotes or whitespace)
#
sub parseCustomLogArg
{
    my ( $arg ) = @_;
    if ($arg =~ /^\s*"(.*?)"/)
    {
        return $1;
    }
    if ($arg =~ /^\s*(\S*)/)
    {
        return $1;
    }
    return $arg;
}

#
# Version of printResult that uses semicolon as a separator and does not take format arguments
#
sub printResult1
{
    my @cols = @_;
    my $count = scalar(@cols);
    print 'em_result=';
    for (my $i = 0; $i < $count; $i++)
    {
        print $cols[$i];
        if ($i < $count - 1)
        {
            print ';';
        }
    }
    print "\n";
}
