#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ohs/LogLevelCheck.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# LogLevelCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LogLevelCheck.pl - Apache FMW integration: get information on directives
#        LogLevel, SSLLogLevel, RewriteLogLevel,ScriptLog,  PlsqlLog           
#        from all OHS confg files
#
#    DESCRIPTION
#        Command line utility called by the Agent to 
#        get information on directives
#        LogLevel, SSLLogLevel, RewriteLogLevel,ScriptLog,  PlsqlLog           
#        from all OHS confg files.
#
#      Implements the LogLevelCheck metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#   jjustiso/ aghanti     06/17/10 - Consider OHS instance id for AS11
#   jjustiso/ jsmoler     05/27/09 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

my $hash = parseApacheConf();

printResult(
    '', 'string',
    'LogLevel', 'string',
    peek($$hash{'LogLevel'}), 'string',
);
printResult(
    '', 'string',
    'SSLLogLevel', 'string',
    peek($$hash{'SSLLogLevel'}), 'string',
);
printResult(
    '', 'string',
    'RewriteLogLevel', 'string',
    peek($$hash{'RewriteLogLevel'}), 'string',
);
printResult(
    '', 'string',
    'ScriptLog', 'string',
    peek($$hash{'ScriptLog'}), 'string',
);
printResult(
    '', 'string',
    'PlsqlLogEnable', 'string',
    peek($$hash{'PlsqlLogEnable'}), 'string',
);



my $vhosts = $$hash{'VirtualHost'};
for my $vhostExpr (keys %{$vhosts})
{
    my $vhostHash = $$vhosts{$vhostExpr};
    printResult(
        $vhostExpr, 'string',
        'LogLevel', 'string',
        peek($$vhostHash{'LogLevel'}), 'string',
    );
    printResult(
        $vhostExpr, 'string',
        'SSLLogLevel', 'string',
        peek($$vhostHash{'SSLLogLevel'}), 'string',
    );
    printResult(
        $vhostExpr, 'string',
        'RewriteLogLevel', 'string',
        peek($$vhostHash{'RewriteLogLevel'}), 'string',
    );
    printResult(
        $vhostExpr, 'string',
        'PlsqlLogEnable', 'string',
        peek($$vhostHash{'PlsqlLogEnable'}), 'string',
    );
}
