#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ohs/getOc4jRoutingMode.pl /main/2 2010/10/07 08:33:20 asunar Exp $
#
# getOc4jRoutingMode.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOc4jRoutingMode.pl - Gets value of "Oc4jRoutingMode" Apache
#        directive.  This metric is only available in 10.1.3+.
#
#    DESCRIPTION
#      Command-line utility called by the agent to retrieve the
#      the value of Oc4jRoutingMode in mod_oc4j.conf.
#
#      Command-line arguments: <oracle home>
#
#      Outputs the value of Oc4jRoutingMode.  This value should be 
#      equal to one of the following:
#        Dynamic
#        Static
#        DynamicOverride
#        StaticOverride (default value)
#
#      If it is equal to some other value, then the invalid
#      value will still be returned, but an error will be
#      printed to the agent perl trace file.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    asunar      10/04/10 - bug 9859640:Setting CCR_OHS_ID in the environment
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    echolank    01/05/06 - print result even if invalid
#    echolank    12/02/05 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;
require "emd_common.pl";

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}
my $hash = parseApacheConf();

my $ref = peek($$hash{'Oc4jRoutingMode'});
if( !$ref )
{
    EMD_PERL_DEBUG("Oc4jRoutingMode is not defined, defaulting to StaticOverride");

    # if Oc4jRoutingMode is not defined, the default is
    # StaticOverride.  i.e. both dynamic and
    # static mount points are used, but static ones take precedence
    $ref = "StaticOverride";
}

if ( $ref ne 'Dynamic'
     && $ref ne 'Static'
     && $ref ne 'StaticOverride'
     && $ref ne 'DynamicOverride')
{
    # print error if the value is unrecognized
    EMD_PERL_ERROR( "Unrecognized Oc4jRoutingMode $ref\n" );
}

# Always print result, even if it is invalid.
# This ensures that the new invalid value is uploaded to
# the repository.  If we chose not to upload the value,
# the old metric value would be retained in the repository.
printResult($ref, 'string');

