#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/ohs/getRoutingIds.pl /main/2 2010/10/07 08:33:20 asunar Exp $
#
# getRoutingIds.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getRoutingIds.pl - Gets the routing IDs specified for the
#        OHS in mod_oc4j.conf or opmn.xml.
#
#    DESCRIPTION
#      Command-line utility called by the agent to retrieve the
#      routing ids for the OHS, defined either in mod_oc4j.conf or
#      opmn.xml.
#
#      Command-line arguments: <oracle home>
#
#      Outputs a line ("em_result={routing-id}") for each of
#      the OHS's routing ids.  If there are no routing ids
#      defined for the OHS, then the default routing id
#      "default" is returned.
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    asunar      10/04/10 - bug 9859640:Setting CCR_OHS_ID in the environment
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/12/07 - support OPMN variables
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    echolank    01/19/06 - support OHS group routing ids 
#    echolank    12/07/05 - Creation
# 

use strict;
use ias::asecm;
use ias::Apache_confFileParser;
use ias::simpleXPath;
require "emd_common.pl";

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

# first check whether the OHS specifies its own set of routing ids
my $hash = parseApacheConf();
my $modOc4jIds = peek($$hash{'Oc4jRoutingID'});
if ( $modOc4jIds )
{
    EMD_PERL_DEBUG("OHS Oc4jRoutingID is defined as " . $modOc4jIds);

    # remove whitespace
    $modOc4jIds =~ s/\s+//g;

    my @ids = split( /,/, $modOc4jIds );
    for my $id ( @ids )
    {
        printResult($id, 'string');
    }
}
else
{
    # OHS does not specify routing IDs.
    # check whether OPMN specifies a routing ID for the OHS.
    my %moduleData = ias::asecm::getOpmnModuleData({
        'ias-component' => 'HTTP_Server',
        'module' => 'OHS',
    });
    my $opmnOhsId = $moduleData{'start-parameters'}{'routing-id'};
    if (defined($opmnOhsId))
    {
        printResult($opmnOhsId, 'string');
    }
    else
    {
        EMD_PERL_DEBUG("OHS has no defined routing IDs, defaulting to default");
        # print default routing id
        printResult('default', 'string');
    }
}
