#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/printWebLogicAssociations.pl /main/4 2010/08/17 21:07:23 jsmoler Exp $
#
# printWebLogicAssociations.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      printWebLogicAssociations.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/11/10 - use WL_HOME as oracle home
#    jsmoler     11/25/08 - use Oracle Home instead of BEA home
#    jsmoler     11/20/08 - add target property
#    jsmoler     11/07/08 - Creation
# 

use strict;

my $hostName = shift(@ARGV);
my $oracleHome = $ENV{'WL_HOME'};

# Find the last association with a unique type, that has a target name
my %assocs = ();
for my $assoc (@ARGV)
{
    my @params = split('\|', $assoc);
    my $assocType = $params[0];
    my $targetName = $params[1];
    if ($targetName eq '' || $targetName =~ /^%.*%$/)
    {
        # Target name is missing
        next;
    }
    $assocs{$assocType} = $assoc;
}
# Print associations including the target property <host name>:<oracle home>
for my $assocType (keys %assocs)
{
    my $assoc = $assocs{$assocType};
    print "em_result=$assoc|$hostName:$oracleHome\n";
}
