#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/webCache/FilePermCheck.pl /main/5 2010/03/31 14:26:55 jsutton Exp $
#
# FilePermCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      
#    NAME
#      FilePermCheck.pl - WebCache: Get "LS" information on webcached
#                             and webcachectl.
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve
#      "LS" information on webcached  and webcachectl.
#                           
#
#      Implements the FilePermCheck metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       jsutton  03/30/10 - AS11 requirements
#       jsmoler  09/10/09 - check if files exist
#       jsutton  08/18/09 - exit vs. return
#       jsmoler  07/29/09 - map to user names
#    jjustiso/jsmoler     05/26/09 - Created
# 

use strict;
use ias::asecm;
use File::stat ();

my $oracleHome = $ARGV[0];

if (-e "$oracleHome/webcache/webcache.xml")
{
    setOracleHome($oracleHome);
}
elsif (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
    $oracleHome = $ENV{ORACLE_HOME};
    setOracleHome($oracleHome);
}

# This health check is for Unix only
if (getPlatform() ne 'unix')
{
    exit;
}

printPermissions("$oracleHome");
printPermissions("$oracleHome/webcache/bin/webcached");
printPermissions("$oracleHome/webcache/bin/webcachectl");

sub printPermissions
{
    my ( $path ) = @_;
    if (! -e $path)
    {
        return;
    }
    my $st = File::stat::stat($path);
    if (defined($st))
    {
        my ( $user ) = getpwuid($st->uid);
        my ( $group ) = getgrgid($st->gid);
        printResult($path, 'path',
                    $st->mode, 'string',
                    $user, 'string',
                    $group, 'string');
    }
}
