#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/webCache/IdentityCheck.pl /main/6 2010/06/22 23:09:59 aghanti Exp $
#
# IdentityCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#       IdentityCheck.pl - WebCache FMW integration: get information on 
#       IDENTITY element in webcache.xml
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve attribute
#      information for the USERID and GROUPID, in the IDENTITY element,
#      in the webcache.xml.
#
#      Implements the IdentityCheck metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  06/17/10 - Consider webcache instance id for AS11
#       jsutton  03/30/10 - AS11 requirements
#       jsmoler  09/10/09 - check if user/group defined
#       jsutton  08/18/09 - exit vs. return
#       jsmoler  07/29/09 - map to user names
#    jjustiso/jsmoler     05/29/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

# This health check is for Unix only
exit if (getPlatform() ne 'unix');

my $cacheName = getMyCache($hostName, $wcId);
exit if (!defined($cacheName));

my $xmlFile = getWebCacheXml($wcId);
exit if (!defined($xmlFile));

my $info = (simpleXPathQuery($xmlFile,
                             'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/IDENTITY'))[0];

my $user = $$info{'USERID'};
if (defined($user) && $user =~ /^[0-9]+$/)
{
    ( $user ) = getpwuid($user);
}
my $group = $$info{'GROUPID'};
if (defined($group) && $group =~ /^[0-9]+$/)
{
    ( $group ) = getgrgid($group);
}

printResult(
    $user,        'string',
    $group,       'string',
);

