#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/webCache/LogGrowthCheck.pl /main/4 2010/06/22 23:09:59 aghanti Exp $
#
# LogGrowthCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LogGrowthCheck.pl - WebCache FMW integration: get element information
#      from webcache.
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve 
#      Information on element EVENTLOG for attribute FREQUENCY, in webcache.xml
#      Information on element ACCESSLOG for attribute ROLLOVERNAME, in webcache.xml
#
#      Implements the LogGrowthCheck metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  06/17/10 - Consider webcache instance id for AS11
#       jsutton  03/30/10 - AS11 requirements
#       jsmoler  09/10/09 - check if webcache.xml exists
#    jjustiso/jsmoler    05/28/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[1];
}

my $xmlFile = getWebCacheXml($wcId);

if (defined($xmlFile) && -e $xmlFile)
{
    my $EVENTLOGATTR = (simpleXPathQuery($xmlFile,
                               'CALYPSO/GENERAL/EVENTLOG/ROLLOVER'))[0];
    my $ACCESSLOGATTR = (simpleXPathQuery($xmlFile,
                               'CALYPSO/GENERAL/ACCESSLOG'))[0];

    printResult(
        $$EVENTLOGATTR{'FREQUENCY'},        'string',
        $$ACCESSLOGATTR{'ROLLOVERNAME'},  'string',
      );
}
