#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/webCache/LogLevelCheck.pl /main/4 2010/06/22 23:09:59 aghanti Exp $
#
# LogLevelCheck.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LogLevelCheck.pl - WebCache FMW  integration: get element 
#      information in webcache.xml
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve element information.
#      on elements VERBOSITY and IOLOGGER in the webcache.xml/
#
#      Implements the LogLevelCheck metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name> <webcache instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  06/17/10 - Consider webcache instance id for AS11
#       jsutton  03/30/10 - AS11 requirements
#       jsmoler  09/10/09 - check if webcache.xml exists
#    jjustiso/jsmoler    05/28/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = $ARGV[2];
}

my $cacheName = getMyCache($hostName, $wcId);
if (!defined($cacheName))
{
    exit;
}

my $xmlFile = getWebCacheXml($wcId);

if (defined($xmlFile) && -e $xmlFile)
{
    my $verbose = (simpleXPathQuery($xmlFile,
                             'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/EVENTLOGDIR/VERBOSITY'))[0];
    my $iologger = (simpleXPathQuery($xmlFile,
                             'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/DIAGNOSTICS/IOLOGGER'))[0];

    printResult(
        $$verbose{'LEVEL'},        'string',
        $$iologger{'ENABLED'},    'string',
    );
}
