# $Header: emll/sysman/admin/scripts/ias/webcache_assoc.pl /main/3 2010/06/22 23:09:59 aghanti Exp $
#
# webcache_assoc.pl
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       webcache_assoc.pl
#
#   DESCRIPTION
#       Returns information on targets associated with this webcache instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#      Command-line arguments: <oracle home> <webcache instance id (AS11 onwards)>
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      aghanti    06/17/10 - Consider webcache instance id for AS11
#      jsutton    03/30/10 - AS11 changes
#      jsutton    09/16/05 - jsutton_ias_assoc
#      jsutton    09/15/05 - initial
##*************************************************************

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;
use ias::asecm;

#
my $oracleHome = shift;
setOracleHome($oracleHome);

my $wcId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: Webcache instance ID has been passed as an argument
  $wcId = shift;
}

my $webcacheXml = getWebCacheXml($wcId);
exit if (!defined($webcacheXml));

my @hosts = simpleXPathQuery($webcacheXml,
                             'CALYPSO/GENERAL/HOST');

for my $host (@hosts)
{
    my $protocol = getListenProtocol($$host{'SSLENABLED'});
    print "em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_APACHE_TYPE|$$host{'NAME'}:$protocol:$$host{'PORT'}\n";
}
1;
# End of the Program
