#!/usr/local/bin/perl -w
# 
# $Header: emll/sysman/admin/scripts/ias/webcenter_portal_app.pl /main/1 2011/10/03 08:36:29 howu Exp $
#
# webcenter_portal_app.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      webcenter_portal_app.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    howu        06/15/11 - collection script for webcenter_portal_app
#    howu        06/15/11 - Creation
# 
 
BEGIN
{
    require "emd_common.pl";
}

use strict;
use warnings;
use File::Find;
use Time::Local;

my ($target_app_name) = @ARGV;

my $file_pattern  ="webcenter_metrics.dat";

package main;

my $middlewareHome = $ENV{'BEA_HOME'};
if (!defined($middlewareHome))
{
    EMD_PERL_DEBUG("No BEA_HOME defined, aborting webcenter_portal_app discovery.");
    exit;
}

my $wlsHome = $ENV{'WL_HOME'};
if (!defined($wlsHome))
{
    EMD_PERL_DEBUG("No WL_HOME defined, aborting webcenter_portal_app discovery.");
    exit;
}

my ($Year, $Month, $Day, $days_of_year, $wday) = (localtime(time))[5, 4, 3, 7, 6];

# construct Janurary 1st to calculate week number later
# Sunday is 0, Saturday is 6
my $jan1 = timelocal(0,0,0,1,0,$Year);
my($jan1_wday) = (localtime($jan1))[6];

# year is the year after 1900 and month starts from 0, increment them
$Year += 1900;
$Month += 1;

# In the OCM environment, Date::Calc is not available, so we must
# calculate the week number
# Add the "offset" (jan1_wday) so that Sundays will always be the beginning
# of a week;
# Add 1 at the end so the week number starts from 1, not 0)
my $WeekNumber = int (($days_of_year + $jan1_wday)/7) + 1;

EMD_PERL_DEBUG("Year = $Year, Month = $Month, Day = $Day, WeekNumber = $WeekNumber");

find(\&process_webcenter_metrics_files, $middlewareHome);

sub process_webcenter_metrics_files {

  my $file_handle = $_;

  my $file = $File::Find::name;

  my $file_name = $file;
  $file_name =~ s,/,\\,g;   # substitute all / with \

  # return unless it is a file (not directory)
  return unless -f $file_handle;

  # return unless file ends with "webenter_metrics.dat"
  return unless $file_name =~ /$file_pattern$/;

  my $file_name_only = ( split m{\\}, $file_name )[-1];

  # extract the year and week number from file
  my $year_from_file = substr($file_name_only, -29, 4);
  my $week_from_file = substr($file_name_only, -24, 2);

  my $index = index($file_name_only, '_');
  my $appName = substr($file_name_only, 0, $index);

  # filter out "unclosed files"
  return unless ($year_from_file eq $Year && $WeekNumber gt $week_from_file);

  # only process file for matching application
  return unless ($target_app_name eq $appName);

  my $renamed_file = substr($file, 0, -3);
  $renamed_file = $renamed_file . "bak";

  my $now = localtime(time);

  open F, $file_handle or print "em_warning=couldn't open $file\n" && return;

  EMD_PERL_DEBUG("opening file $file for uploading.");

  # The collection file generated by the WebCenter runtime code is 
  # already in pipe-delimited format, just retrieve the contents
  while (<F>) {
    my($line) = $_;

    if($line)
    {
      # trim white spaces
      $line =~ s/^\s+|\s+$//g;

      if($line ne "")
      {
        print 'em_result='.$line."\n";
      }
    }

  }

  close F;

  # rename file after processing so it won't be used next time
  EMD_PERL_DEBUG("uploaded $file, remaning it to $renamed_file");
  rename($file, $renamed_file);
}

