#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/JMSQueue.pl /main/3 2008/12/24 15:03:41 jsmoler Exp $
#
# JMSQueues.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      JMSQueues.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/23/08 - fix 7665185
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use File::Spec;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @jmsDescriptorNames = getServerComponentNames($configFile, 'jms-system-resource', $serverName);
for my $descriptorName (@jmsDescriptorNames)
{
    my $moduleName = $descriptorName;
    my $descriptorFileName = (ias::simpleXPath::queryForText($configFile,
        'domain/jms-system-resource[name="' . $descriptorName . '"]/descriptor-file-name'))[0];
    $descriptorFileName = File::Spec->rel2abs($descriptorFileName, "$domainHome/config");
    if (-e $descriptorFileName)
    {
        my $descriptorFile = ias::simpleXPath::parseFile($descriptorFileName);
        my @queues = ias::simpleXPath::queryForNodes($descriptorFile, 'weblogic-jms/queue');
        for my $queue (@queues)
        {
            print 'em_result='
                  . $$queue{'attributes'}{'name'}
            . '|' . $moduleName
            . '|' . (ias::simpleXPath::queryForText($queue, 'queue/jndi-name'))[0]
            . '|' . (ias::simpleXPath::queryForText($queue, 'queue/maximum-message-size'))[0]
            . '|' . (ias::simpleXPath::queryForText($queue, 'queue/thresholds/bytes-high'))[0]
            . '|' . (ias::simpleXPath::queryForText($queue, 'queue/thresholds/messages-high'))[0]
            . "\n";
        }
    }
}
