#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/JoltConnectionPool.pl /main/2 2008/11/21 16:12:14 jsmoler Exp $
#
# JoltConnectionPools.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      JoltConnectionPools.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @names = getServerComponentNames($configFile, 'jolt-connection-pool', $serverName);
for my $name (@names)
{
    my $joltConnPool = (ias::simpleXPath::queryForNodes($configFile,
        'domain/jolt-connection-pool[name="' . $name. '"]'))[0];
    print 'em_result=' . $name
    . '|' . (ias::simpleXPath::queryForText($joltConnPool,
                'jolt-connection-pool/primary-address'))[0]
    . '|' . (ias::simpleXPath::queryForText($joltConnPool,
                'jolt-connection-pool/failover-address'))[0]
    . '|' . (ias::simpleXPath::queryForText($joltConnPool,
                'jolt-connection-pool/minimum-pool-size'))[0]
    . '|' . (ias::simpleXPath::queryForText($joltConnPool,
                'jolt-connection-pool/maximum-pool-size'))[0]
    . '|' . (ias::simpleXPath::queryForText($joltConnPool,
                'jolt-connection-pool/recv-timeout'))[0]
    . "\n";
}
