#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/ResourceConfig.pl /main/2 2008/11/21 16:12:14 jsmoler Exp $
#
# Resource.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      Resource.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use ias::simpleXPath;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my $argStr = (ias::simpleXPath::queryForText($configFile,
            'domain/server[name="' . $serverName . '"]/server-start/arguments'))[0];
my @args = split(/\s/, $argStr);

my $startHeap;
my $maxHeap;

for my $arg (@args)
{
    if ($arg =~ /-Xms([0-9]+)/)
    {
        $startHeap = $1;
    }
    elsif ($arg =~ /-Xmx([0-9]+)/)
    {
        $maxHeap = $1;
    }
}

print "em_result=$startHeap|$maxHeap\n";
