#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/Server.pl /main/5 2010/03/09 13:20:02 jsmoler Exp $
#
# Server.pl
#
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Server.pl - Collects general WebLogic server configuration
#
#    DESCRIPTION
#      Collects general WebLogic server configuration.
#      Implements the Server metric defined in weblogic_j2eeserver.xml.
#      Command-line arguments: <scripts dir> <domain home> <server name> <admin server>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     03/03/10 - add max post size
#    jsmoler     10/12/09 - XbranchMerge jsmoler_bug-8982342 from
#                           st_emll_10.3.2
#    jsmoler     10/09/09 - add domain home
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/10/08 - move schema support to simpleXPath
#    jsmoler     10/27/08 - Creation
# 

use strict;
use ias::simpleXPath;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my $server = (ias::simpleXPath::queryForNodes($configFile,
    'domain/server[name="' . $serverName . '"]'))[0];

print 'em_result='
      . (ias::simpleXPath::queryForText($server, 'server/listen-port'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server[name="' . $adminServer. '"]/listen-port'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/native-io-enabled'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/max-open-sock-count'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/stuck-thread-max-time'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/stuck-thread-timer-interval'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/accept-backlog'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/login-timeout-millis'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/managed-server-independence-enabled'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/low-memory-gc-threshold'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/low-memory-granularity-level'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/low-memory-sample-size'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/low-memory-time-interval'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/ssl/listen-port'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/ssl/login-timeout-millis'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/cluster'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/cluster-weight'))[0]
. '|' . (ias::simpleXPath::queryForText($server, 'server/machine'))[0]
. '|' . $domainHome
. '|' . (ias::simpleXPath::queryForText($server, 'server/web-server/max-post-size'))[0]
. "\n";
