# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/ServerConfigUtil.pm /main/2 2010/04/06 13:06:47 jsmoler Exp $
#
# ServerConfigUtil.pm
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ServerConfigUtil.pm - Server configuration utilities
#
#    DESCRIPTION
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/06/10 - fix cluster name query
#    jsmoler     11/09/08 - Creation
# 

package ias::weblogic_j2eeserver::ServerConfigUtil;

use strict;
use Exporter 'import';
use ias::simpleXPath;

our @EXPORT = qw(
    getServerComponentNames
);

sub getServerComponentNames
{
    my ( $configFile, $componentPath, $serverName ) = @_;

    my @components = ias::simpleXPath::queryForNodes($configFile, "domain/$componentPath");
    my $componentTag = (split('/', $componentPath))[-1];
    
    my $clusterName = (ias::simpleXPath::queryForText($configFile,
        'domain/server[name="' . $serverName . '"]/cluster'))[0];

    my %matchingNames = ();
    for my $component (@components)
    {
        my $name = (ias::simpleXPath::queryForText($component, "$componentTag/name"))[0];
        my $targetStr = (ias::simpleXPath::queryForText($component, "$componentTag/target"))[0];
        my @targets = split(',', $targetStr);
        for my $target (@targets)
        {
            if ($target eq $serverName || (defined($clusterName) && $target eq $clusterName))
            {
                $matchingNames{$name} = 1;
                last;
            }
        }
    }
    return keys %matchingNames;
}

return 1;
