#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/VirtualHost.pl /main/3 2010/04/13 12:45:01 jsmoler Exp $
#
# VirtualHosts.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      VirtualHosts.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/13/10 - network access point
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @vhostNames = getServerComponentNames($configFile, 'virtual-host', $serverName);
for my $name (@vhostNames)
{
    my $vhost = (ias::simpleXPath::queryForNodes($configFile,
        'domain/virtual-host[name="' . $name . '"]'))[0];
    print 'em_result='
          . $name
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/deployment-order'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/frontend-host'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/frontend-http-port'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/frontend-https-port'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/virtual-host-name'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/network-access-point'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/web-server-log/file-name'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/web-server-log/logging-enabled'))[0]
    . '|' . (ias::simpleXPath::queryForText($vhost, 'virtual-host/max-post-size'))[0]
    . "\n";
}
