#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/weblogic_j2eeserver/WorkManager.pl /main/3 2010/04/13 12:45:01 jsmoler Exp $
#
# WorkManagers.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WorkManagers.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/12/10 - handle constraints referenced by name
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @names = getServerComponentNames($configFile, 'self-tuning/work-manager', $serverName);
for my $name (@names)
{
    my $workManager = (ias::simpleXPath::queryForNodes($configFile,
        'domain/self-tuning/work-manager[name="' . $name. '"]'))[0];

    # Check for a response time or fair share request class
    my $reqClassType;
    my $reqClassName;
    my $responseTimeReqClass = (ias::simpleXPath::queryForText($workManager,
        'work-manager/response-time-request-class'))[0];
    my $fairShareReqClass = (ias::simpleXPath::queryForText($workManager,
        'work-manager/fair-share-request-class'))[0];
    if (defined($responseTimeReqClass))
    {
        $reqClassType = 'ResponseTimeRequestClass';
        $reqClassName = $responseTimeReqClass;
    }
    elsif (defined($fairShareReqClass))
    {
        $reqClassType = 'FairShareRequestClass';
        $reqClassName = $fairShareReqClass;
    }

    print 'em_result='
          . $name
    . '|' . (ias::simpleXPath::queryForText($workManager, 'work-manager/ignore-stuck-threads'))[0]
    . '|' . getConstraintCount($workManager, 'min-threads-constraint')
    . '|' . getConstraintCount($workManager, 'max-threads-constraint')
    . '|' . $reqClassType
    . '|' . $reqClassName
    . '|' . getConstraintCount($workManager, 'capacity')
    . "\n";
}

sub getConstraintCount
{
    my ( $workManagerNode, $constraint ) = @_;

    # Look up the constraint tag under the work manager tag
    my $node = (ias::simpleXPath::queryForNodes($workManagerNode, 'work-manager/' . $constraint))[0];
    if (!defined($node))
    {
        return undef;
    }
    # Check for a count tag under the constraint tag
    my $countNode = (ias::simpleXPath::getChildren($node, 'count'))[0];
    if (defined($countNode))
    {
        # The count tag should have the actual numeric value
        my $count = ias::simpleXPath::getStringValue($countNode);
        return $count;
    }
    # Get the value of the constraint tag, which may be a number or a name
    my $count = ias::simpleXPath::getStringValue($node);
    if ($count =~ /^-?[0-9]+$/)
    {
        return $count;
    }
    # A non-numeric value is a name which references a different part of the config file
    my $name = $count;
    $count = (ias::simpleXPath::queryForText($configFile, 'domain/self-tuning/' . $constraint . '[name="' . $name . '"]/count'))[0];
    return $count;
}
