# $Header: ias_1022_jserv.pl 20-nov-2003.08:09:21 jsutton Exp $
#
# ias_1022_jserv.pl
# 
# Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      ias_1022_jserv.pl - gets Oracle JServ statistics from the AggreSpy servlet
#
#
#    DESCRIPTION
#      ias_1022_jserv.pl <AggreSpy_url> <metric>
#
#      where:
#         <AggreSpy_url> the url of the AggreSpy servlet for this web server.
#           example: http://foo:7777/AggreSpy?nountype=JVM
#         <metric> the metric category: JServJSP, JServJSPServlet, OPM, JServServlet,
#                                       JServZone, JServServer, or JVM
#
#    returns: a "|" separated list of values
#          example: em_result=Name|FullName|Process|Host|pid.value|upTime.value|
#                           cpuTime.value|heapSize.value|host.value|totMem.value
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     11/20/03 - Use correct tracing routine 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    rzazueta    04/23/02 - fix bug 2339897
#    rzazueta    04/02/02 - rzazueta_add_ias_1022_targets
#    rzazueta    03/28/02 - Creation
# 

require "emd_common.pl";
require HTTP::Request;
require LWP::UserAgent;

my $metric;
my $url;
my $machine;
my $port;
my $ua;
my $request; 
my $response;
my @lines;
my $unit;
my $attr;

($url, $metric) = @ARGV;

($machine, $port) = ( $url =~ m!.*://(.*):([^/]*)/.*$! );

$ua = LWP::UserAgent->new;
#$ua->agent("AgentName/0.1 " . $ua->agent);

#form request
$request = new HTTP::Request GET => $url;

#get response
$response = $ua->request($request);
#EMD_TRACE("Got response from $machine");

#check for error
if($response->is_error) 
{
    # some error occured..let's inform the EDM about it
    print "em_error=Error occured getting ".$url."\n";
    EMD_PERL_DEBUG("Error occured getting $url: $!.\n", "$machine");
    exit;
} 

# no error
#    EMD_TRACE("Parsing URL.\n");

if ($metric eq "JVM")
{
  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);     #remove leading and trailing spaces
    SWITCH:
    {
        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JVM]", remove it from 
        #   "/hostName/processName/JVM [type=JVM]"
        if ($line =~ s/\s*\[type=JVM\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # JVM
	    # Fullname is /hostName/processName:port/JVM
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"totalMemory.maxValue"}        = "";
            $attr{"totalMemory.minValue"}        = "";
            $attr{"totalMemory.value"}           = "";
            $attr{"freeMemory.maxValue"}         = "";
            $attr{"freeMemory.minValue"}         = "";
            $attr{"freeMemory.value"}            = "";
            $attr{"activeThreads.maxValue"}      = "";
            $attr{"activeThreads.minValue"}      = "";
            $attr{"activeThreads.value"}         = "";
            $attr{"activeThreadGroups.maxValue"} = "";
            $attr{"activethreadGroups.minValue"} = "";
            $attr{"activeThreadGroups.value"}    = "";

	    last SWITCH;
	}
	    
        #if "totalMemory.maxValue : #### kbytes", remove "totalMemory.maxValue: "
        if ($line =~ s/totalMemory\.maxValue:\s*//)         
        { 
	    ($attr{"totalMemory.maxValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "totalMemory.minValue : #### kbytes", remove "totalMemory.minValue: "
        if ($line =~ s/totalMemory\.minValue:\s*//)         
        { 
	    ($attr{"totalMemory.minValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "totalMemory.value : #### kbytes", remove "totalMemory.value: "
        if ($line =~ s/totalMemory\.value:\s*//)         
        { 
	    ($attr{"totalMemory.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

        #if "freeMemory.maxValue : #### kbytes", remove "freeMemory.maxValue: "
        if ($line =~ s/freeMemory\.maxValue:\s*//)         
        { 
	    ($attr{"freeMemory.maxValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "freeMemory.minValue : #### kbytes", remove "freeMemory.minValue: "
        if ($line =~ s/freeMemory\.minValue:\s*//)         
        { 
	    ($attr{"freeMemory.minValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "freeMemory.value : #### kbytes", remove "freeMemory.value: "
        if ($line =~ s/freeMemory\.value:\s*//)         
        { 
	    ($attr{"freeMemory.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

        #if "activeThreads.maxValue : #### threads", remove "activeThreads.maxValue: "
        if ($line =~ s/activeThreads\.maxValue:\s*//)         
        { 
	    ($attr{"activeThreads.maxValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "activeThreads.minValue : #### threads", remove "activeThreads.minValue: "
        if ($line =~ s/activeThreads\.minValue:\s*//)         
        { 
	    ($attr{"activeThreads.minValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "activeThreads.value : #### threads", remove "activeThreads.value: "
        if ($line =~ s/activeThreads\.value:\s*//)         
        { 
	    ($attr{"activeThreads.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

        #if "activeThreadGroups.maxValue : #### groups", remove "activeThreadGroups.maxValue: "
        if ($line =~ s/activeThreadGroups\.maxValue:\s*//)         
        { 
	    ($attr{"activeThreadGroups.maxValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "activeThreadGroups.minValue : #### groups", remove "activeThreadGroups.minValue: "
        if ($line =~ s/activeThreadGroups\.minValue:\s*//)         
        { 
	    ($attr{"activeThreadGroups.minValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
        #if "activeThreadGroups.value : #### groups", remove "activeThreadGroups.value: "
        if ($line =~ s/activeThreadGroups\.value:\s*//)         
        { 
	    ($attr{"activeThreadGroups.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
	          . $attr{"Name"} 
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"totalMemory.maxValue"}
	    . "|" . $attr{"totalMemory.minValue"}
	    . "|" . $attr{"totalMemory.value"}
	    . "|" . $attr{"freeMemory.maxValue"}
	    . "|" . $attr{"freeMemory.minValue"}
	    . "|" . $attr{"freeMemory.value"}
	    . "|" . $attr{"activeThreads.maxValue"}
	    . "|" . $attr{"activeThreads.minValue"}
	    . "|" . $attr{"activeThreads.value"}
	    . "|" . $attr{"activeThreadGroups.maxValue"}
	    . "|" . $attr{"activeThreadGroups.minValue"}
	    . "|" . $attr{"activeThreadGroups.value"}
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "OPM")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces

    SWITCH:
    {

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JServServer]", remove it from 
        #   "/hostName/processName/jserv_server [type=JServServer]"
	if ($line =~ s/\s*\[type=JServServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServServer"} = $line;         # jserv_server
	    last SWITCH;
	}
 
        #if " [type=OPM]", remove it from "/hostName/processName/jserv_server/OPM [type=OPM]"
        if ($line =~ s/\s*\[type=OPM\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # OPM

	    # Fullname is /hostName/processName:port/jserv_server/OPM
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"JServServer"}."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"Status.value"}      = "";   
	    $attr{"moduleName.value"}  = "";
	    $attr{"groupName.value"}   = "";
	    $attr{"groupID.value"}     = "";
	    $attr{"opmProcID.value"}   = "";
	    $attr{"apacheHost.value"}  = "";
	    $attr{"apachePort.value"}  = "";
	    $attr{"readyStatus.value"} = "";
	    last SWITCH;
	}
	
	#if "Status.value: ####", remove "Status.value: "
        if ($line =~ s/^Status\.value:\s*//)
        { 
	    ($attr{"Status.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "moduleName.value: ####", remove "moduleName.value: "
        if ($line =~ s/moduleName\.value:\s*//)
        { 
	    ($attr{"moduleName.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "groupName.value: ####", remove "groupName.value: "
        if ($line =~ s/groupName\.value:\s*//)
        { 
	    ($attr{"groupName.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "groupID.value: ####", remove "groupID.value: "
        if ($line =~ s/groupID\.value:\s*//)
        { 
	    ($attr{"groupID.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "opmProcID.value: ####", remove "opmProcID.value: "
        if ($line =~ s/opmProcID\.value:\s*//)
        { 
	    ($attr{"opmProcID.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "apacheHost.value: ####", remove "apacheHost.value: "
        if ($line =~ s/apacheHost\.value:\s*//)
        { 
	    ($attr{"apacheHost.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "apachePort.value: ####", remove "apachePort.value: "
        if ($line =~ s/apachePort\.value:\s*//)
        { 
	    ($attr{"apachePort.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "readyStatus.value: ####", remove "readyStatus.value: "
        if ($line =~ s/readyStatus\.value:\s*//)
        { 
	    ($attr{"readyStatus.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"JServServer"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"Status.value"} 
	    . "|" . $attr{"moduleName.value"} 
	    . "|" . $attr{"groupName.value"} 
	    . "|" . $attr{"groupID.value"} 
	    . "|" . $attr{"opmProcID.value"} 
	    . "|" . $attr{"apacheHost.value"} 
	    . "|" . $attr{"apachePort.value"} 
	    . "|" . $attr{"readyStatus.value"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "JServJSPServlet")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces

    SWITCH:
    {

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JServServer]", remove it from 
        #   "/hostName/processName/jserv_server [type=JServServer]"
	if ($line =~ s/\s*\[type=JServServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServServer"} = $line;         # jserv_server
	    last SWITCH;
	}
 
        #if " [type=JServZone]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone [type=JServZone]"
	if ($line =~ s/\s*\[type=JServZone\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServZone"} = $line;           # jserv_zone
	    last SWITCH;
	}
 
        #if " [type=JServJSPServlet]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone/jserv_jspservlet [type=JServJSPServlet]"
        if ($line =~ s/\s*\[type=JServJSPServlet\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # jserv_jspservlet

	    # Fullname is /hostName/processName:port/jserv_server/jserv_zone/jserv_jspservlet/
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"JServServer"}."/".$attr{"JServZone"}
                               ."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"loadServlet.active"}    = "";
            $attr{"loadServlet.avg"}       = "";
            $attr{"loadServlet.maxTime"}   = "";
            $attr{"loadServlet.mintime"}   = "";
            $attr{"loadServlet.completed"} = "";
            $attr{"loadServlet.time"}      = "";
            $attr{"loadServletClasses.active"}    = "";
            $attr{"loadServletClasses.ave"}       = "";
            $attr{"loadServletClasses.maxTime"}   = "";
            $attr{"loadServletClasses.minTime"}   = "";
            $attr{"loadServletClasses.completed"} = "";
            $attr{"loadServletClasses.time"}      = "";
	    last SWITCH;
	}
	
	#if "loadServlet.active: ####", remove "loadServlet.active: "
        if ($line =~ s/loadServlet\.active:\s*//)
        { 
	    ($attr{"loadServlet.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.avg: #### msecs", remove "loadServlet.avg: "
        if ($line =~ s/loadServlet\.avg:\s*//)
        { 
	    ($attr{"loadServlet.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.maxTime: #### msecs", remove "loadServlet.maxTime: "
        if ($line =~ s/loadServlet\.maxTime:\s*//)
        { 
	    ($attr{"loadServlet.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.minTime: #### msecs", remove "loadServlet.minTime: "
        if ($line =~ s/loadServlet\.minTime:\s*//)
        { 
	    ($attr{"loadServlet.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.completed: #### ops", remove "loadServlet.completed: "
        if ($line =~ s/loadServlet\.completed:\s*//)
        { 
	    ($attr{"loadServlet.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.time: #### msecs", remove "loadServlet.time: "
        if ($line =~ s/loadServlet\.time:\s*//)
        { 
	    ($attr{"loadServlet.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "loadServletClasses.active: ####", remove "loadServletClasses.active: "
        if ($line =~ s/loadServletClasses\.active:\s*//)
        { 
	    ($attr{"loadServletClasses.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.avg: #### msecs", remove "loadServletClasses.avg: "
        if ($line =~ s/loadServletClasses\.avg:\s*//)
        { 
	    ($attr{"loadServletClasses.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.maxTime: #### msecs", remove "loadServletClasses.maxTime: "
        if ($line =~ s/loadServletClasses\.maxTime:\s*//)
        { 
	    ($attr{"loadServletClasses.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.minTime: #### msecs", remove "loadServletClasses.minTime: "
        if ($line =~ s/loadServletClasses\.minTime:\s*//)
        { 
	    ($attr{"loadServletClasses.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.completed: #### ops", remove "loadServletClasses.completed: "
        if ($line =~ s/loadServletClasses\.completed:\s*//)
        { 
	    ($attr{"loadServletClasses.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.time: #### msecs", remove "loadServletClasses.time: "
        if ($line =~ s/loadServletClasses\.time:\s*//)
        { 
	    ($attr{"loadServletClasses.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"JServZone"}
	    . "|" . $attr{"JServServer"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"loadServlet.active"} 
	    . "|" . $attr{"loadServlet.avg"} 
	    . "|" . $attr{"loadServlet.maxTime"} 
	    . "|" . $attr{"loadServlet.minTime"} 
	    . "|" . $attr{"loadServlet.completed"} 
	    . "|" . $attr{"loadServlet.time"} 
	    . "|" . $attr{"loadServletClasses.active"} 
	    . "|" . $attr{"loadServletClasses.avg"} 
	    . "|" . $attr{"loadServletClasses.maxTime"} 
	    . "|" . $attr{"loadServletClasses.minTime"} 
	    . "|" . $attr{"loadServletClasses.completed"} 
	    . "|" . $attr{"loadServletClasses.time"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "JServJSP")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces

    SWITCH:
    {

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JServServer]", remove it from 
        #   "/hostName/processName/jserv_server [type=JServServer]"
	if ($line =~ s/\s*\[type=JServServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServServer"} = $line;         # jserv_server
	    last SWITCH;
	}
 
        #if " [type=JServZone]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone [type=JServZone]"
	if ($line =~ s/\s*\[type=JServZone\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServZone"} = $line;           # jserv_zone
	    last SWITCH;
	}
 
        #if " [type=JServJSPServlet]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone/jserv_jspservlet [type=JServJSPServlet]"
        if ($line =~ s/\s*\[type=JServJSPServlet\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServJSPServlet"} = $line;     # jserv_jspservlet
	    last SWITCH;
	}
	
        #if " [type=JServJSP]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone/jserv_jspservlet/jserv_jsp [type=JServJSP]"
        if ($line =~ s/\s*\[type=JServJSP\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # jserv_jsp

	    # Fullname is /hostName/processName:port/jserv_server/jserv_zone/jserv_jspservlet/jserv_jsp
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"JServServer"}."/".$attr{"JServZone"}
                               ."/".$attr{"JServJSPServlet"}."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"processRequest.active"}    = "";
            $attr{"processRequest.avg"}       = "";
            $attr{"processRequest.maxTime"}   = "";
            $attr{"processRequest.mintime"}   = "";
            $attr{"processRequest.completed"} = "";
            $attr{"processRequest.time"}      = "";
            $attr{"serviceRequest.active"}    = "";
            $attr{"serviceRequest.avg"}       = "";
            $attr{"serviceRequest.maxTime"}   = "";
            $attr{"serviceRequest.mintime"}   = "";
            $attr{"serviceRequest.completed"} = "";
            $attr{"serviceRequest.time"}      = "";
            $attr{"createSession.active"}     = "";
            $attr{"createSession.ave"}        = "";
            $attr{"createSession.maxTime"}    = "";
            $attr{"createSession.minTime"}    = "";
            $attr{"createSession.completed"}  = "";
            $attr{"createSession.time"}       = "";
	    last SWITCH;
	}

	#if "processRequest.active: ####", remove "processRequest.active: "
        if ($line =~ s/processRequest\.active:\s*//)
        { 
	    ($attr{"processRequest.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.avg: #### msecs", remove "processRequest.avg: "
        if ($line =~ s/processRequest\.avg:\s*//)
        { 
	    ($attr{"processRequest.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.maxTime: #### msecs", remove "processRequest.maxTime: "
        if ($line =~ s/processRequest\.maxTime:\s*//)
        { 
	    ($attr{"processRequest.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.minTime: #### msecs", remove "processRequest.minTime: "
        if ($line =~ s/processRequest\.minTime:\s*//)
        { 
	    ($attr{"processRequest.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.completed: #### ops", remove "processRequest.completed: "
        if ($line =~ s/processRequest\.completed:\s*//)
        { 
	    ($attr{"processRequest.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.time: #### msecs", remove "processRequest.time: "
        if ($line =~ s/processRequest\.time:\s*//)
        { 
	    ($attr{"processRequest.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "serviceRequest.active: ####", remove "serviceRequest.active: "
        if ($line =~ s/serviceRequest\.active:\s*//)
        { 
	    ($attr{"serviceRequest.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.avg: #### msecs", remove "serviceRequest.avg: "
        if ($line =~ s/serviceRequest\.avg:\s*//)
        { 
	    ($attr{"serviceRequest.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.maxTime: #### msecs", remove "serviceRequest.maxTime: "
        if ($line =~ s/serviceRequest\.maxTime:\s*//)
        { 
	    ($attr{"serviceRequest.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.minTime: #### msecs", remove "serviceRequest.minTime: "
        if ($line =~ s/serviceRequest\.minTime:\s*//)
        { 
	    ($attr{"serviceRequest.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.completed: #### ops", remove "serviceRequest.completed: "
        if ($line =~ s/serviceRequest\.completed:\s*//)
        { 
	    ($attr{"serviceRequest.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.time: #### msecs", remove "serviceRequest.time: "
        if ($line =~ s/serviceRequest\.time:\s*//)
        { 
	    ($attr{"serviceRequest.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "createSession.active: ####", remove "createSession.active: "
        if ($line =~ s/createSession\.active:\s*//)
        { 
	    ($attr{"createSession.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.avg: #### msecs", remove "createSession.avg: "
        if ($line =~ s/createSession\.avg:\s*//)
        { 
	    ($attr{"createSession.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.maxTime: #### msecs", remove "createSession.maxTime: "
        if ($line =~ s/createSession\.maxTime:\s*//)
        { 
	    ($attr{"createSession.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.minTime: #### msecs", remove "createSession.minTime: "
        if ($line =~ s/createSession\.minTime:\s*//)
        { 
	    ($attr{"createSession.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.completed: #### ops", remove "createSession.completed: "
        if ($line =~ s/createSession\.completed:\s*//)
        { 
	    ($attr{"createSession.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.time: #### msecs", remove "createSession.time: "
        if ($line =~ s/createSession\.time:\s*//)
        { 
	    ($attr{"createSession.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"JServJSPServlet"}
	    . "|" . $attr{"JServZone"}
	    . "|" . $attr{"JServServer"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"processRequest.active"} 
	    . "|" . $attr{"processRequest.avg"} 
	    . "|" . $attr{"processRequest.maxTime"} 
	    . "|" . $attr{"processRequest.minTime"} 
	    . "|" . $attr{"processRequest.completed"} 
	    . "|" . $attr{"processRequest.time"} 
	    . "|" . $attr{"serviceRequest.active"} 
	    . "|" . $attr{"serviceRequest.avg"} 
	    . "|" . $attr{"serviceRequest.maxTime"} 
	    . "|" . $attr{"serviceRequest.minTime"} 
	    . "|" . $attr{"serviceRequest.completed"} 
	    . "|" . $attr{"serviceRequest.time"} 
	    . "|" . $attr{"createSession.active"} 
	    . "|" . $attr{"createSession.avg"} 
	    . "|" . $attr{"createSession.maxTime"} 
	    . "|" . $attr{"createSession.minTime"} 
	    . "|" . $attr{"createSession.completed"} 
	    . "|" . $attr{"createSession.time"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "JServServlet")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces

    SWITCH:
    {

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JServServer]", remove it from 
        #   "/hostName/processName/jserv_server [type=JServServer]"
	if ($line =~ s/\s*\[type=JServServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServServer"} = $line;         # jserv_server
	    last SWITCH;
	}
 
        #if " [type=JServZone]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone [type=JServZone]"
	if ($line =~ s/\s*\[type=JServZone\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServZone"} = $line;           # jserv_zone
	    last SWITCH;
	}
 
        #if " [type=JServServlet]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone/jserv_servlet [type=JServServlet]"
        if ($line =~ s/\s*\[type=JServServlet\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # jserv_servlet

	    # Fullname is /hostName/processName:port/jserv_server/jserv_zone/jserv_servlet
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"JServServer"}."/".$attr{"JServZone"}
                               ."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"processRequest.active"}    = "";
            $attr{"processRequest.avg"}       = "";
            $attr{"processRequest.maxTime"}   = "";
            $attr{"processRequest.mintime"}   = "";
            $attr{"processRequest.completed"} = "";
            $attr{"processRequest.time"}      = "";
            $attr{"serviceRequest.active"}    = "";
            $attr{"serviceRequest.avg"}       = "";
            $attr{"serviceRequest.maxTime"}   = "";
            $attr{"serviceRequest.mintime"}   = "";
            $attr{"serviceRequest.completed"} = "";
            $attr{"serviceRequest.time"}      = "";
            $attr{"loadServlet.active"}    = "";
            $attr{"loadServlet.avg"}       = "";
            $attr{"loadServlet.maxTime"}   = "";
            $attr{"loadServlet.mintime"}   = "";
            $attr{"loadServlet.completed"} = "";
            $attr{"loadServlet.time"}      = "";
            $attr{"loadServletClasses.active"}    = "";
            $attr{"loadServletClasses.ave"}       = "";
            $attr{"loadServletClasses.maxTime"}   = "";
            $attr{"loadServletClasses.minTime"}   = "";
            $attr{"loadServletClasses.completed"} = "";
            $attr{"loadServletClasses.time"}      = "";
            $attr{"createSession.active"}     = "";
            $attr{"createSession.ave"}        = "";
            $attr{"createSession.maxTime"}    = "";
            $attr{"createSession.minTime"}    = "";
            $attr{"createSession.completed"}  = "";
            $attr{"createSession.time"}       = "";
	    last SWITCH;
	}

	#if "processRequest.active: ####", remove "processRequest.active: "
        if ($line =~ s/processRequest\.active:\s*//)
        { 
	    ($attr{"processRequest.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.avg: #### msecs", remove "processRequest.avg: "
        if ($line =~ s/processRequest\.avg:\s*//)
        { 
	    ($attr{"processRequest.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.maxTime: #### msecs", remove "processRequest.maxTime: "
        if ($line =~ s/processRequest\.maxTime:\s*//)
        { 
	    ($attr{"processRequest.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.minTime: #### msecs", remove "processRequest.minTime: "
        if ($line =~ s/processRequest\.minTime:\s*//)
        { 
	    ($attr{"processRequest.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.completed: #### ops", remove "processRequest.completed: "
        if ($line =~ s/processRequest\.completed:\s*//)
        { 
	    ($attr{"processRequest.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.time: #### msecs", remove "processRequest.time: "
        if ($line =~ s/processRequest\.time:\s*//)
        { 
	    ($attr{"processRequest.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "serviceRequest.active: ####", remove "serviceRequest.active: "
        if ($line =~ s/serviceRequest\.active:\s*//)
        { 
	    ($attr{"serviceRequest.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.avg: #### msecs", remove "serviceRequest.avg: "
        if ($line =~ s/serviceRequest\.avg:\s*//)
        { 
	    ($attr{"serviceRequest.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.maxTime: #### msecs", remove "serviceRequest.maxTime: "
        if ($line =~ s/serviceRequest\.maxTime:\s*//)
        { 
	    ($attr{"serviceRequest.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.minTime: #### msecs", remove "serviceRequest.minTime: "
        if ($line =~ s/serviceRequest\.minTime:\s*//)
        { 
	    ($attr{"serviceRequest.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.completed: #### ops", remove "serviceRequest.completed: "
        if ($line =~ s/serviceRequest\.completed:\s*//)
        { 
	    ($attr{"serviceRequest.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "serviceRequest.time: #### msecs", remove "serviceRequest.time: "
        if ($line =~ s/serviceRequest\.time:\s*//)
        { 
	    ($attr{"serviceRequest.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "loadServlet.active: ####", remove "loadServlet.active: "
        if ($line =~ s/loadServlet\.active:\s*//)
        { 
	    ($attr{"loadServlet.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.avg: #### msecs", remove "loadServlet.avg: "
        if ($line =~ s/loadServlet\.avg:\s*//)
        { 
	    ($attr{"loadServlet.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.maxTime: #### msecs", remove "loadServlet.maxTime: "
        if ($line =~ s/loadServlet\.maxTime:\s*//)
        { 
	    ($attr{"loadServlet.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.minTime: #### msecs", remove "loadServlet.minTime: "
        if ($line =~ s/loadServlet\.minTime:\s*//)
        { 
	    ($attr{"loadServlet.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.completed: #### ops", remove "loadServlet.completed: "
        if ($line =~ s/loadServlet\.completed:\s*//)
        { 
	    ($attr{"loadServlet.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServlet.time: #### msecs", remove "loadServlet.time: "
        if ($line =~ s/loadServlet\.time:\s*//)
        { 
	    ($attr{"loadServlet.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "loadServletClasses.active: ####", remove "loadServletClasses.active: "
        if ($line =~ s/loadServletClasses\.active:\s*//)
        { 
	    ($attr{"loadServletClasses.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.avg: #### msecs", remove "loadServletClasses.avg: "
        if ($line =~ s/loadServletClasses\.avg:\s*//)
        { 
	    ($attr{"loadServletClasses.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.maxTime: #### msecs", remove "loadServletClasses.maxTime: "
        if ($line =~ s/loadServletClasses\.maxTime:\s*//)
        { 
	    ($attr{"loadServletClasses.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.minTime: #### msecs", remove "loadServletClasses.minTime: "
        if ($line =~ s/loadServletClasses\.minTime:\s*//)
        { 
	    ($attr{"loadServletClasses.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.completed: #### ops", remove "loadServletClasses.completed: "
        if ($line =~ s/loadServletClasses\.completed:\s*//)
        { 
	    ($attr{"loadServletClasses.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadServletClasses.time: #### msecs", remove "loadServletClasses.time: "
        if ($line =~ s/loadServletClasses\.time:\s*//)
        { 
	    ($attr{"loadServletClasses.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
        }

	#if "createSession.active: ####", remove "createSession.active: "
        if ($line =~ s/createSession\.active:\s*//)
        { 
	    ($attr{"createSession.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.avg: #### msecs", remove "createSession.avg: "
        if ($line =~ s/createSession\.avg:\s*//)
        { 
	    ($attr{"createSession.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.maxTime: #### msecs", remove "createSession.maxTime: "
        if ($line =~ s/createSession\.maxTime:\s*//)
        { 
	    ($attr{"createSession.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.minTime: #### msecs", remove "createSession.minTime: "
        if ($line =~ s/createSession\.minTime:\s*//)
        { 
	    ($attr{"createSession.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.completed: #### ops", remove "createSession.completed: "
        if ($line =~ s/createSession\.completed:\s*//)
        { 
	    ($attr{"createSession.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "createSession.time: #### msecs", remove "createSession.time: "
        if ($line =~ s/createSession\.time:\s*//)
        { 
	    ($attr{"createSession.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"JServZone"}
	    . "|" . $attr{"JServServer"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"processRequest.active"} 
	    . "|" . $attr{"processRequest.avg"} 
	    . "|" . $attr{"processRequest.maxTime"} 
	    . "|" . $attr{"processRequest.minTime"} 
	    . "|" . $attr{"processRequest.completed"} 
	    . "|" . $attr{"processRequest.time"} 
	    . "|" . $attr{"serviceRequest.active"} 
	    . "|" . $attr{"serviceRequest.avg"} 
	    . "|" . $attr{"serviceRequest.maxTime"} 
	    . "|" . $attr{"serviceRequest.minTime"} 
	    . "|" . $attr{"serviceRequest.completed"} 
	    . "|" . $attr{"serviceRequest.time"} 
	    . "|" . $attr{"loadServlet.active"} 
	    . "|" . $attr{"loadServlet.avg"} 
	    . "|" . $attr{"loadServlet.maxTime"} 
	    . "|" . $attr{"loadServlet.minTime"} 
	    . "|" . $attr{"loadServlet.completed"} 
	    . "|" . $attr{"loadServlet.time"} 
	    . "|" . $attr{"loadServletClasses.active"} 
	    . "|" . $attr{"loadServletClasses.avg"} 
	    . "|" . $attr{"loadServletClasses.maxTime"} 
	    . "|" . $attr{"loadServletClasses.minTime"} 
	    . "|" . $attr{"loadServletClasses.completed"} 
	    . "|" . $attr{"loadServletClasses.time"} 
	    . "|" . $attr{"createSession.active"} 
	    . "|" . $attr{"createSession.avg"} 
	    . "|" . $attr{"createSession.maxTime"} 
	    . "|" . $attr{"createSession.minTime"} 
	    . "|" . $attr{"createSession.completed"} 
	    . "|" . $attr{"createSession.time"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "JServZone")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces

    SWITCH:
    {

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JServServer]", remove it from 
        #   "/hostName/processName/jserv_server [type=JServServer]"
	if ($line =~ s/\s*\[type=JServServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"JServServer"} = $line;         # jserv_server
	    last SWITCH;
	}
 
        #if " [type=JServZone]", remove it from 
        #   "/hostName/processName/jserv_server/jserv_zone [type=JServZone]"
	if ($line =~ s/\s*\[type=JServZone\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # jserv_zone

	    # Fullname is /hostName/processName:port/jserv_server/jserv_zone
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"JServServer"}."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"processRequest.active"}    = "";
            $attr{"processRequest.avg"}       = "";
            $attr{"processRequest.maxTime"}   = "";
            $attr{"processRequest.mintime"}   = "";
            $attr{"processRequest.completed"} = "";
            $attr{"processRequest.time"}      = "";
            $attr{"checkReload.active"}    = "";
            $attr{"checkReload.avg"}       = "";
            $attr{"checkReload.maxTime"}   = "";
            $attr{"checkReload.mintime"}   = "";
            $attr{"checkReload.completed"} = "";
            $attr{"checkReload.time"}      = "";
            $attr{"activeSessions.value"}  = "";
            $attr{"readSession.count"}     = "";
            $attr{"writeSession.count"}    = "";
            $attr{"loadFailed.count"}      = "";
	    last SWITCH;
	}

	#if "processRequest.active: ####", remove "processRequest.active: "
        if ($line =~ s/processRequest\.active:\s*//)
        { 
	    ($attr{"processRequest.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.avg: #### msecs", remove "processRequest.avg: "
        if ($line =~ s/processRequest\.avg:\s*//)
        { 
	    ($attr{"processRequest.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.maxTime: #### msecs", remove "processRequest.maxTime: "
        if ($line =~ s/processRequest\.maxTime:\s*//)
        { 
	    ($attr{"processRequest.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.minTime: #### msecs", remove "processRequest.minTime: "
        if ($line =~ s/processRequest\.minTime:\s*//)
        { 
	    ($attr{"processRequest.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.completed: #### ops", remove "processRequest.completed: "
        if ($line =~ s/processRequest\.completed:\s*//)
        { 
	    ($attr{"processRequest.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "processRequest.time: #### msecs", remove "processRequest.time: "
        if ($line =~ s/processRequest\.time:\s*//)
        { 
	    ($attr{"processRequest.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "checkReload.active: ####", remove "checkReload.active: "
        if ($line =~ s/checkReload\.active:\s*//)
        { 
	    ($attr{"checkReload.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "checkReload.avg: #### msecs", remove "checkReload.avg: "
        if ($line =~ s/checkReload\.avg:\s*//)
        { 
	    ($attr{"checkReload.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "checkReload.maxTime: #### msecs", remove "checkReload.maxTime: "
        if ($line =~ s/checkReload\.maxTime:\s*//)
        { 
	    ($attr{"checkReload.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "checkReload.minTime: #### msecs", remove "checkReload.minTime: "
        if ($line =~ s/checkReload\.minTime:\s*//)
        { 
	    ($attr{"checkReload.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "checkReload.completed: #### ops", remove "checkReload.completed: "
        if ($line =~ s/checkReload\.completed:\s*//)
        { 
	    ($attr{"checkReload.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "checkReload.time: #### msecs", remove "checkReload.time: "
        if ($line =~ s/checkReload\.time:\s*//)
        { 
	    ($attr{"checkReload.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "activeSessions.value: #### sessions", remove "activeSessions.value: "
        if ($line =~ s/activeSessions\.value:\s*//)
        { 
	    ($attr{"activeSessions.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "readSession.count: #### ops", remove "readSession.count: "
        if ($line =~ s/readSession\.count:\s*//)
        { 
	    ($attr{"readSession.count"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "writeSession.count: #### ops", remove "writeSession.count: "
        if ($line =~ s/writeSession\.count:\s*//)
        { 
	    ($attr{"writeSession.count"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "loadFailed.count: #### ops", remove "loadFailed.count: "
        if ($line =~ s/loadFailed\.count:\s*//)
        { 
	    ($attr{"loadFailed.count"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"JServServer"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"processRequest.active"} 
	    . "|" . $attr{"processRequest.avg"} 
	    . "|" . $attr{"processRequest.maxTime"} 
	    . "|" . $attr{"processRequest.minTime"} 
	    . "|" . $attr{"processRequest.completed"} 
	    . "|" . $attr{"processRequest.time"} 
	    . "|" . $attr{"checkReload.active"} 
	    . "|" . $attr{"checkReload.avg"} 
	    . "|" . $attr{"checkReload.maxTime"} 
	    . "|" . $attr{"checkReload.minTime"} 
	    . "|" . $attr{"checkReload.completed"} 
	    . "|" . $attr{"checkReload.time"} 
	    . "|" . $attr{"activeSessions.value"} 
	    . "|" . $attr{"readSession.count"} 
	    . "|" . $attr{"writeSession.count"} 
	    . "|" . $attr{"loadFailed.count"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "JServServer")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces

    SWITCH:
    {

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=JServServer]", remove it from 
        #   "/hostName/processName/jserv_server [type=JServServer]"
	if ($line =~ s/\s*\[type=JServServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # jserv_server

	    # Fullname is /hostName/processName:port/jserv_server/jserv_zone
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"activeConnections.maxValue"}    = "";
            $attr{"activeConnections.value"}       = "";
            $attr{"idlePeriod.maxTime"}   = "";
            $attr{"idlePeriod.mintime"}   = "";
            $attr{"idlePeriod.completed"} = "";
            $attr{"idlePeriod.time"}      = "";
            $attr{"readRequest.active"}    = "";
            $attr{"readRequest.avg"}       = "";
            $attr{"readRequest.maxTime"}   = "";
            $attr{"readRequest.mintime"}   = "";
            $attr{"readRequest.completed"} = "";
            $attr{"readRequest.time"}      = "";
            $attr{"port.value"}            = "";
            $attr{"host.value"}            = "";
            $attr{"connectLimit.value"}    = "";
            $attr{"maxBacklog.value"}       = "";
	    last SWITCH;
	}

	#if "activeConnections.maxValue: #### threads", remove "activeConnections.maxValue: "
        if ($line =~ s/activeConnections\.maxValue:\s*//)
        { 
	    ($attr{"activeConnections.maxValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "activeConnections.value: #### threads", remove "activeConnections.value: "
        if ($line =~ s/activeConnections\.value:\s*//)
        { 
	    ($attr{"activeConnections.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "idlePeriod.maxTime: #### msecs", remove "idlePeriod.maxTime: "
        if ($line =~ s/idlePeriod\.maxTime:\s*//)
        { 
	    ($attr{"idlePeriod.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "idlePeriod.minTime: #### msecs", remove "idlePeriod.minTime: "
        if ($line =~ s/idlePeriod\.minTime:\s*//)
        { 
	    ($attr{"idlePeriod.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "idlePeriod.completed: #### ops", remove "idlePeriod.completed: "
        if ($line =~ s/idlePeriod\.completed:\s*//)
        { 
	    ($attr{"idlePeriod.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "idlePeriod.time: #### msecs", remove "idlePeriod.time: "
        if ($line =~ s/idlePeriod\.time:\s*//)
        { 
	    ($attr{"idlePeriod.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "readRequest.active: ####", remove "readRequest.active: "
        if ($line =~ s/readRequest\.active:\s*//)
        { 
	    ($attr{"readRequest.active"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "readRequest.avg: #### msecs", remove "readRequest.avg: "
        if ($line =~ s/readRequest\.avg:\s*//)
        { 
	    ($attr{"readRequest.avg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "readRequest.maxTime: #### msecs", remove "readRequest.maxTime: "
        if ($line =~ s/readRequest\.maxTime:\s*//)
        { 
	    ($attr{"readRequest.maxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "readRequest.minTime: #### msecs", remove "readRequest.minTime: "
        if ($line =~ s/readRequest\.minTime:\s*//)
        { 
	    ($attr{"readRequest.minTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "readRequest.completed: #### ops", remove "readRequest.completed: "
        if ($line =~ s/readRequest\.completed:\s*//)
        { 
	    ($attr{"readRequest.completed"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "readRequest.time: #### msecs", remove "readRequest.time: "
        if ($line =~ s/readRequest\.time:\s*//)
        { 
	    ($attr{"readRequest.time"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "port.value: ####", remove "port.value: "
        if ($line =~ s/port\.value:\s*//)
        { 
	    ($attr{"port.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "host.value: ####", remove "host.value: "
        if ($line =~ s/host\.value:\s*//)
        { 
	    ($attr{"host.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "connectLimit.value: #### connections", remove "connectLimit.value: "
        if ($line =~ s/connectLimit\.value:\s*//)
        { 
	    ($attr{"connectLimit.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "maxBacklog.value: #### requests", remove "maxBacklog.value: "
        if ($line =~ s/maxBacklog\.value:\s*//)
        { 
	    ($attr{"maxBacklog.value"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"activeConnections.maxValue"} 
	    . "|" . $attr{"activeConnections.value"} 
	    . "|" . $attr{"connectLimit.value"} 
	    . "|" . $attr{"host.value"} 
	    . "|" . $attr{"idlePeriod.completed"} 
	    . "|" . $attr{"idlePeriod.maxTime"} 
	    . "|" . $attr{"idlePeriod.minTime"} 
	    . "|" . $attr{"idlePeriod.time"} 
	    . "|" . $attr{"maxBacklog.value"} 
	    . "|" . $attr{"port.value"} 
	    . "|" . $attr{"readRequest.active"} 
	    . "|" . $attr{"readRequest.avg"} 
	    . "|" . $attr{"readRequest.completed"} 
	    . "|" . $attr{"readRequest.maxTime"} 
	    . "|" . $attr{"readRequest.minTime"} 
	    . "|" . $attr{"readRequest.time"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

