# $Header: ias_1022_ohs.pl 20-nov-2003.08:09:22 jsutton Exp $
#
# ias_1022_ohs.pl
# 
# Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      ias_1022_ohs.pl - gets Oracle HTTP Server (apache) statistics 
#                        from the AggreSpy servlet 
#
#    DESCRIPTION
#      ias_1022_ohs.pl <AggreSpy_url> <metric>
#
#      where:
#         <AggreSpy_url> the url of the AggreSpy servlet for this web server.
#           example: http://foo:7777/AggreSpy?nountype=CDMSProcess
#         <metric> the metric category: CDMSProcess, ApacheModule, or ApacheServer
#
#    returns: a "|" separated list of values
#          example: em_result=Name|FullName|Process|Host|pid.value|upTime.value|
#                           cpuTime.value|heapSize.value|host.value|totMem.value
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     11/20/03 - Use correct tracing routine 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    rzazueta    04/23/02 - fix bug 2339897
#    rzazueta    04/02/02 - rzazueta_add_ias_1022_targets
#    rzazueta    03/25/02 - Creation
# 

require "emd_common.pl";
require HTTP::Request;
require LWP::UserAgent;

my $metric;
my $url;
my $machine;
my $port;
my $ua;
my $request; 
my $response;
my @lines;
my $unit;
my $attr;

($url, $metric) = @ARGV;

($machine, $port) = ( $url =~ m!.*://(.*):([^/]*)/.*$! );

$ua = LWP::UserAgent->new;
#$ua->agent("AgentName/0.1 " . $ua->agent);

#form request
$request = new HTTP::Request GET => $url;

#get response
$response = $ua->request($request);
#EMD_TRACE("Got response from $machine");

#check for error
if($response->is_error) 
{
    # some error occured..let's inform the EDM about it
    print "em_error=Error occured getting ".$url."\n";
    EMD_PERL_DEBUG("Error occured getting $url: $!.\n", "$machine");
    exit;
} 

# no error
#    EMD_TRACE("Parsing URL.\n");

if ($metric eq "CDMSProcess")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);     #remove leading and trailing spaces
    SWITCH:
    {
        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=CDMSProcess]", remove it from 
        #   "/hostName/processName/cdmsProcessName [type=CDMSProcess]"
        if ($line =~ s/\s*\[type=CDMSProcess\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # cdmsProcessName
	    # Fullname is /hostName/processName:port/cdmsProcessName
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}."/".$attr{"Name"};

	    # Initialize metric values
	    $attr{"pid"}      = "";
	    $attr{"upTime"}   = "";
	    $attr{"cpuTime"}  = "";
	    $attr{"heapSize"} = "";
	    $attr{"host"}     = "";
	    $attr{"totMem"}   = ""; 
	    last SWITCH;
	}
	    
        #if "pid.value : ####", remove "pid.value: "
        if ($line =~ s/pid\.value:\s*//) 
	{
	    ($attr{"pid"}, $unit) = ( $line =~ m!(.*) (.*)! );
	    last SWITCH;
	}

        #if "upTime.value : #### msecs", remove "upTime.value: "
        if ($line =~ s/upTime\.value:\s*//)         
        { 
	    ($attr{"upTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

        #if "cpuTime.value : #### msecs", remove "cpuTime.value: "
        if ($line =~ s/cpuTime\.value:\s*//)        
	{
	    ($attr{"cpuTime"}, $unit) = ( $line =~ m!(.*) (.*)! );
	    last SWITCH;
	}

        #if "heapSize.value : #### kilobytes", remove "heapSize.value: "
        if ($line =~ s/heapSize\.value:\s*//)
        {
	    ($attr{"heapSize"}, $unit) = ( $line =~ m!(.*) (.*)! );
	    last SWITCH;
	}

        #if "host.value : ####", remove "host.value: "
        if ($line =~ s/host\.value:\s*//)
	{
	    ($attr{"host"}, $unit) = ( $line =~ m!(.*) (.*)! );
	    last SWITCH;
	}

        #if "totMem.value : ####", remove "totMem.value: "
        if ($line =~ s/totMem\.value:\s*//)
	{
	    $attr{"totMem"} = ""; # $attr{"totMem"}=$line; reads "not implemented"
	    print "em_result=" 
	          . $attr{"Name"} 
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"pid"}
	    . "|" . $attr{"upTime"}
	    . "|" . $attr{"cpuTime"}
	    . "|" . $attr{"heapSize"}
	    . "|" . $attr{"host"}
	    . "|" . $attr{"totMem"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "ApacheModule")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading and trailing spaces
    SWITCH:
    {
        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=ApacheServer]", remove it from 
        #   "/hostName/processName/ohs_server [type=ApacheServer]"
	if ($line =~ s/\s*\[type=ApacheServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"ohs_server"} = $line;          # ohs_server
	    last SWITCH;
	}
 
        #if " [type=ApacheModule]", remove it from 
        #   "/hostName/processName/ohs_server/Modules/moduleName [type=ApacheModule]"
        if ($line =~ s/\s*\[type=ApacheModule\]//) 
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # cdmsProcessName

	    # Fullname is /hostName/processName:port/ohs_server/Modules/moduleName
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}
	                       ."/".$attr{"ohs_server"}."/Modules/".$attr{"Name"};

	    # Initialize metric values
            $attr{"declineCount"}      = "";   
	    $attr{"handleCompleted"}   = "";
	    $attr{"handleTime"}        = "";
	    $attr{"handleActive"}      = "";
	    $attr{"handleAvg"}         = "";
	    $attr{"handleMinTime"}     = "";
	    $attr{"handleMaxTime"}     = "";
	    last SWITCH;
	}
	
        #if "decline.count: #### ops", remove "decline.count: "
        if ($line =~ s/decline\.count:\s*//)
        { 
	    ($attr{"declineCount"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "handle.completed: ####", remove "handle.completed: "
        if ($line =~ s/handle\.completed:\s*//)
        { 
	    ($attr{"handleCompleted"}, $unit) = ( $line =~ m!(.*) (.*)! );
	    last SWITCH;
	}

	#if "handle.time: #### usecs", remove "handle.time: "
        if ($line =~ s/handle\.time:\s*//)
        { 
	    ($attr{"handleTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "handle.active: #### threads", remove "handle.active: "
        if ($line =~ s/handle\.active:\s*//)
        { 
	    ($attr{"handleActive"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "handle.avg: #### usecs", remove "handle.avg: "
        if ($line =~ s/handle\.avg:\s*//)
        { 
	    ($attr{"handleAvg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "handle.minTime : #### usecs", remove "handle.minTime: "
        if ($line =~ s/handle\.minTime:\s*//)
        { 
	    ($attr{"handleMinTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "handle.maxTime : #### usecs", remove "handle.maxTime: "
        if ($line =~ s/handle\.maxTime:\s*//)
        { 
	    ($attr{"handleMaxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"ohs_server"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"declineCount"}
	    . "|" . $attr{"handleCompleted"}
	    . "|" . $attr{"handleTime"}
	    . "|" . $attr{"handleActive"}
	    . "|" . $attr{"handleAvg"}
	    . "|" . $attr{"handleMinTime"}
	    . "|" . $attr{"handleMaxTime"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

if ($metric eq "Host")
{
    @lines = split(/\n/,$response->content);

    foreach $line (@lines) {

	($line) = ($line =~ m!^\s*(.*)\s*$!);     #remove leading and trailing spaces

        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                       # remove leading forward slash
	    $attr{"Name"} = $line;                 # hostName
	    $attr{"FullName"} = "/".$attr{"Name"}; # Fullname is /hostName 

	    print "em_result=" 
	          . $attr{"Name"} 
	    . "|" . $attr{"FullName"}
	    . "\n";
	    exit;
	}
  } # end of foreach
  exit;
}

if ($metric eq "Process")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);     #remove leading and trailing spaces
    SWITCH:
    {
        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash

	    if (!($line =~ /JServ/))              # ignore JServ processes
	    {
		$attr{"Name"} = $line . ":" . $port;  # processName:port
		# Fullname is /hostName/processName:port
		$attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Name"};

		print "em_result=" 
		    . $attr{"Name"} 
		. "|" . $attr{"FullName"}
		. "|" . $attr{"Host"}
		. "\n";
	    }
            last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}


if ($metric eq "ApacheServer")
{

  @lines = split(/\n/,$response->content);

  foreach $line (@lines) {
    ($line) = ($line =~ m!^\s*(.*)\s*$!);         # remove leading/trailing spaces
    SWITCH:
    {
        #if " [type=Host]", remove it from "/hostName [type=Host]" 
        if ($line =~ s/\s*\[type=Host\]//)
	{
	    $line =~ s/\///;                      # remove leading forward slash
	    $attr{"Host"} = $line;                # hostName
	    last SWITCH;
	}

        #if " [type=Process]", remove it from "/hostName/processName [type=Process]"
	if ($line =~ s/\s*\[type=Process\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $line = $line . ":" . $port;          # processName:port
	    $attr{"Process"} = $line;             # processName:port
	    last SWITCH;
	}
 
        #if " [type=ApacheServer]", remove it from 
        #   "/hostName/processName/ohs_server [type=ApacheServer]"
	if ($line =~ s/\s*\[type=ApacheServer\]//)
        {
	    ($line) = ( $line =~ m!.*/(.*)! );    # remove up to last forward slash
	    $attr{"Name"} = $line;                # ohs_server

	    # Fullname is /hostName/processName:port/ohs_server
	    $attr{"FullName"} = "/".$attr{"Host"}."/".$attr{"Process"}."/".$attr{"Name"};

	    # Initialize metric values
            $attr{"childStartCount"}       = "";
            $attr{"childFinishCount"}      = "";
            $attr{"connectionCompleted"}   = "";
            $attr{"connectionTime"}        = "";
            $attr{"connectionActive"}      = "";
            $attr{"connectionAvg"}         = "";
            $attr{"connectionMinTime"}     = "";
            $attr{"connectionMaxTime"}     = "";
            $attr{"requestCompleted"}      = "";
            $attr{"requestTime"}           = "";
            $attr{"requestActive"}         = "";
            $attr{"requestAvg"}            = "";
            $attr{"requestMinTime"}        = "";
            $attr{"requestMaxTime"}        = "";
	    $attr{"handleCompleted"}       = "";
	    $attr{"handleTime"}            = "";
	    $attr{"handleActive"}          = "";
	    $attr{"handleAvg"}             = "";
	    $attr{"handleMinTime"}         = "";
	    $attr{"handleMaxTime"}         = "";
            $attr{"numModsValue"}          = "";
            $attr{"internalRedirectCount"} = "";
	    last SWITCH;
	}
	    
	#if "childStart.count: #### ops", remove "childStart.count: "
        if ($line =~ s/childStart\.count:\s*//)
        { 
	    ($attr{"childStartCount"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "childFinish.count: #### ops", remove "childFinish.count: "
        if ($line =~ s/childFinish\.count:\s*//)
        { 
	    ($attr{"childFinishCount"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "connection.completed: ####", remove "connection.completed: "
        if ($line =~ s/connection\.completed:\s*//)
        { 
	    ($attr{"connectionCompleted"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "connection.time: #### usecs", remove "connection.time: "
        if ($line =~ s/connection\.time:\s*//)
        { 
	    ($attr{"connectionTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "connection.active: #### threads", remove "connection.active: "
        if ($line =~ s/connection\.active:\s*//)
        { 
	    ($attr{"connectionActive"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "connection.avg: #### usecs", remove "connection.avg: "
        if ($line =~ s/connection\.avg:\s*//)
        { 
	    ($attr{"connectionAvg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "connection.minTime: #### usecs", remove "connection.minTime: "
        if ($line =~ s/connection\.minTime:\s*//)
        { 
	    ($attr{"connectionMinTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "connection.maxTime: #### usecs", remove "connection.maxTime: "
        if ($line =~ s/connection\.maxTime:\s*//)
        { 
	    ($attr{"connectionMaxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "request.completed: ####", remove "request.completed: "
        if ($line =~ s/request\.completed:\s*//)
        { 
	    ($attr{"requestCompleted"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "request.time: #### usecs", remove "request.time: "
        if ($line =~ s/request\.time:\s*//)
        { 
	    ($attr{"requestTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "request.active: #### threads", remove "request.active: "
        if ($line =~ s/request\.active:\s*//)
        { 
	    ($attr{"requestActive"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "request.avg: #### usecs", remove "request.avg: "
        if ($line =~ s/request\.avg:\s*//)
        { 
	    ($attr{"requestAvg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "request.minTime: #### usecs", remove "request.minTime: "
        if ($line =~ s/request\.minTime:\s*//)
        { 
	    ($attr{"requestMinTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "request.maxTime: #### usecs", remove "request.maxTime: "
        if ($line =~ s/request\.maxTime:\s*//)
        { 
	    ($attr{"requestMaxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}

	#if "handle.completed: ####", remove "handle.completed: "
        if ($line =~ s/handle\.completed:\s*//)
        { 
	    ($attr{"handleCompleted"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "handle.time: #### usecs", remove "handle.time: "
        if ($line =~ s/handle\.time:\s*//)
        { 
	    ($attr{"handleTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "handle.active: #### threads", remove "handle.active: "
        if ($line =~ s/handle\.active:\s*//)
        { 
	    ($attr{"handleActive"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "handle.avg: #### usecs", remove "handle.avg: "
        if ($line =~ s/handle\.avg:\s*//)
        { 
	    ($attr{"handleAvg"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "handle.minTime: #### usecs", remove "handle.minTime: "
        if ($line =~ s/handle\.minTime:\s*//)
        { 
	    ($attr{"handleMinTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "handle.maxTime: #### usecs", remove "handle.maxTime: "
        if ($line =~ s/handle\.maxTime:\s*//)
        { 
	    ($attr{"handleMaxTime"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}


	#if "numMods.value: ####", remove "numMods.value: "
        if ($line =~ s/numMods\.value:\s*//)
        { 
	    ($attr{"numModsValue"}, $unit) = ( $line =~ m!(.*) (.*)! ); 
	    last SWITCH;
	}
	#if "internalRedirect.count: #### usecs", remove "internalRedirect.count: "
        if ($line =~ s/internalRedirect\.count:\s*//)
        { 
	    ($attr{"internalRedirectCount"}, $unit) = ( $line =~ m!(.*) (.*)! ); 

	    print "em_result=" 
  		  . $attr{"Name"}
	    . "|" . $attr{"FullName"}
	    . "|" . $attr{"Process"}
	    . "|" . $attr{"Host"}
	    . "|" . $attr{"childStartCount"}
	    . "|" . $attr{"childFinishCount"}
	    . "|" . $attr{"connectionCompleted"}
	    . "|" . $attr{"connectionTime"}
	    . "|" . $attr{"connectionActive"}
	    . "|" . $attr{"connectionAvg"}
	    . "|" . $attr{"connectionMinTime"}
	    . "|" . $attr{"connectionMaxTime"} 
	    . "|" . $attr{"requestCompleted"}
	    . "|" . $attr{"requestTime"}
	    . "|" . $attr{"requestActive"}
	    . "|" . $attr{"requestAvg"}
	    . "|" . $attr{"requestMinTime"}
	    . "|" . $attr{"requestMaxTime"} 
	    . "|" . $attr{"handleCompleted"}
	    . "|" . $attr{"handleTime"}
	    . "|" . $attr{"handleActive"}
	    . "|" . $attr{"handleAvg"}
	    . "|" . $attr{"handleMinTime"}
	    . "|" . $attr{"handleMaxTime"}
	    . "|" . $attr{"numModsValue"}
	    . "|" . $attr{"internalRedirectCount"} 
	    . "\n";
	    last SWITCH;
	}
    } # end of SWITCH:
  } # end of foreach
  exit;
}

