# $Header: iasntresourceusage.pl 03-feb-2006.09:16:58 jmcclung Exp $
#
# Copyright (c) 2003, 2006, Oracle. All rights reserved.  
#
# iasntresourceusage.pl
#
# EM Management Console statistics
#
# If EMD_ROOT is not set, the program will exit;
# The assumption on the "nmupm.exe procInfo [PID]:
#
#   em_result=2968|0.00|83460|43320|6.61|1289|24|07-00:38:43
#              pid  cpu        mem
#
# The assumption on the "nmupm.exe topProcs"
#
#   em_result=2984|emagent|N/A|5.78|0.00|37864|40504|0
#              pid     app           cpu   mem
#
# Result Format:
#
# Returns: 
#    em_result=<component-name>|<status>|<uptime>|<starttime>|<cpuUsage>|
#    <physicalMemoryUsage>
# 
#    MODIFIED   (MM/DD/YY)
#    jmcclung   02/03/06 - XbranchMerge jmcclung_bug-4963182 from 
#                          st_emasgc_10.2.0.1.1 
#    klmichae   09/26/05 - pass emdroot to iasntresourceusage 
#    jsutton    01/24/05 - Make TMPFILE name unique per PID 
#    klmichae   09/03/04 - get modification time, not creation time 
#    jsutton    04/28/04 - Merge 3451947 changes to MAIN 
#    jsutton    03/10/04 - jsutton_bug-3044386_main 
#    jsutton    09/24/03 - Finishing up Win32 support 
#
# Created by Cheng Han, Steven Frann
#
use File::stat;

sub getNTResourceUsage
{
  # check the basic environment settings
  $emdRoot = shift(@_);
  if ($emdRoot eq "")
  {
    print "EMD_ROOT must be set, abort\n";
    exit(1);
  }
  $oraHome = shift(@_);
  if ($oraHome eq "")
  {
    print "ORACLE_HOME must be set, abort\n";
    exit(1);
  }

  $TMPFILE = "$emdRoot/sysman/log/topprocs.tmp".$$;
  system("$emdRoot/bin/nmupm.exe topProcs > $TMPFILE");

  $now = time();
  $nowMs = $now * 1000;

  # iASConsole
  # emagent
  # JServ
  # em watchDog (accumlative statistics of Perl)
  # opmn

  $PID_FILE = "$oraHome/bin/emctl.pid";
  if (-e "$PID_FILE")
  {
    ($cpuPct, $memKb, $componentStatus) = getProcInfoFromPidFile($PID_FILE, $TMPFILE);
    $memMb = $memKb / 1024;
    $startTime = getPidFileTime($PID_FILE);
    $startTime = $startTime*1000;
    $upTime = $nowMs - $startTime;
    print "em_result=console|$componentStatus|$upTime|$startTime|$cpuPct|$memMb\n";
  }
  else
  {
    print "em_result=console|0||||\n";
  }

  $PID_FILE = "$oraHome/bin/emctl.pid_agent";
  if (-e "$PID_FILE")
  {
    ($cpuPct, $memKb, $componentStatus) = getProcInfoFromPidFile($PID_FILE, $TMPFILE);
    $memMb = $memKb / 1024;
    $startTime = getPidFileTime($PID_FILE);
    $startTime = $startTime*1000;
    $upTime = $nowMs - $startTime;
    print "em_result=agent|$componentStatus|$upTime|$startTime|$cpuPct|$memMb\n";
  }
  else
  {
    print "em_result=agent|0||||\n";
  }

  $PID_FILE = "$oraHome/Apache/Apache/logs/jvm.pids";
  if (-e "$PID_FILE")
  {
    ($cpuPct, $memKb, $componentStatus) = getProcInfoFromPidFile($PID_FILE, $TMPFILE);
    $memMb = $memKb / 1024;
    $startTime = getPidFileTime($PID_FILE);
    $startTime = $startTime*1000;
    $upTime = $nowMs - $startTime;
    print "em_result=JServ|$componentStatus|$upTime|$startTime|$cpuPct|$memMb\n";
  }
  else
  {
    print "em_result=JServ|0||||\n";
  }

  $PID_FILE = "$oraHome/sysman/log/em.nohup";
  if (-e "$PID_FILE")
  {
    ($cpuPct, $memKb, $componentStatus) = getAppInfoByName('perl', $TMPFILE);
    $memMb = $memKb / 1024;
    $startTime = getPidFileTime($PID_FILE);
    $startTime = $startTime*1000;
    $upTime = $nowMs - $startTime;
    print "em_result=watchdog|$componentStatus|$upTime|$startTime|$cpuPct|$memMb\n";
  }
  else
  {
    print "em_result=watchdog|0||||\n";
  }

  ($cpuPct, $memKb, $componentStatus) = getAppInfoByName('opmn', $TMPFILE);
  $memMb = $memKb / 1024;
  $startTime = getPidFileTime("$oraHome/opmn/conf/.formfactor");
  $startTime = $startTime*1000;
  $upTime = $nowMs - $startTime;
  print "em_result=opmn|$componentStatus|$upTime|$startTime|$cpuPct|$memMb\n";
  # remove temp file
  unlink $TMPFILE;
}

# Return the CPU percentage and memory usage
# @param application key word, such as "perl" for EM watch dog
#
sub getAppInfoByName
{
  local($appName, $TMPFILE) = @_;

  $appMemKB  = 0;
  $appCPUPct = 0;
  $appStatus = 0;

  open (TOPPROCs, $TMPFILE) || die "Can not open file $TMPFILE: $!\n";
  while (<TOPPROCs>) 
  {
    $line = $_;
    if (/.$appName./)  
    {
       @process_info = split( '\|', $line);
       $appCPUPct += $process_info[4];
       $appMemKB  += $process_info[5];
       $appStatus = 1;
    }
  }
  close(TOPPROCs);
  return ($appCPUPct, $appMemKB, $appStatus);
}

# Assumption: When pid file is created, the process starts.  Ignoring the
# reasonable amount of error difference, we take this convenient path.
# Return in milliseconds
sub getPidFileTime
{
  local ($PID_FILE) = @_;
  $sb = stat($PID_FILE);
  return $sb->mtime;
}

# REturn cpu percent usage and memory consumption (in KB)
# @param Full path to the PID file, such as D:\oracle\m16core\...\emctl.pid
#
sub getProcInfoFromPidFile
{
  local($PID_FILE, $TMPFILE) = @_;
  $procID = checkPIDFile( $PID_FILE );
  $appMemKB  = 0;
  $appCPUPct = 0;
  $appStatus = 0;

  open (TOPPROCs, $TMPFILE) || die "Can not open file $TMPFILE: $!\n";
  while (<TOPPROCs>) 
  {
    $line = $_;
    if (/.$procID./)  
    {
       @process_info = split( '\|', $line);
       $appCPUPct += $process_info[4];
       $appMemKB  += $process_info[5];
       $appStatus = 1;
    }
  }
  close(TOPPROCs);
  return ($appCPUPct, $appMemKB, $appStatus);
}

# Internal function module, never exposed to the top level logic
# @return the process id in its original format.  If the file happens to 
# contain more than one pid, the first value will be returned
# @param full path to the PID file

sub checkPIDFile
{
    local ($PID_FILE) = @_;
    my $PID = -1;
    # escape special char
    # $PID_FILE = $ENV{PID_FILE};
    # $PID_FILE = "emctlpid";
    if ( -e "$PID_FILE" )
    {
       open(PIDFILE, "<$PID_FILE");
       while(<PIDFILE>)
       {
         $PID = $_;
       }
       close(PIDFILE);
       chomp($PID);
   }
   return $PID
}

1;
