use strict;

use File::Spec;
use ias::simpleXPath;

my ($ibmHome) = @ARGV;
my $versionDir = File::Spec->catdir($ibmHome, "properties","version");


if( -e $versionDir)
{
    if(opendir(VER_DIR,$versionDir))
    {
	my @files = grep {/\.component$/ }  readdir(VER_DIR);
        foreach my $file (@files)
        {
	    $file = File::Spec->catdir($versionDir, $file);
            my @productFamily = simpleXPathQuery($file, "component");
            for my $prod (@productFamily)
            {
                print ("em_result=". 
                        $$prod{'name'}. "|".
                        $$prod{'spec-version'}. "|".
                        $$prod{'build-version'}. "|".
                        $$prod{'build-date'}.  "\n");
            }
        }
    }
    else
    {
        print "Cannot open dir $!\n";
    }
}
