use strict;

use File::Spec;
use ias::simpleXPath;

my ($ibmHome) = @ARGV;
my $versionDir = File::Spec->catdir($ibmHome, "properties","version");


if( -e $versionDir)
{
    if(opendir(VER_DIR,$versionDir))
    {
	my @files = grep {/\.product$/ }  readdir(VER_DIR);
        foreach my $file (@files)
        {
	    $file = File::Spec->catdir($versionDir, $file);
use strict;

		my @productFamily = simpleXPathQuery($file, "product");
		for my $prod (@productFamily)
		{
			my $name = $$prod{'name'};
			print ("em_result=". $name);
			my @prod_IDs = simpleXPathQueryForText($file, 'product/[@name="'. $$prod{'name'} .'"]/id');
                        print ("|");
                        for (my $i = 0; $i < @prod_IDs; $i++)
			{
				print($prod_IDs[$i]);
                                if($i != (@prod_IDs - 1 ))
                                {
                                        print(",");
                                }
			}

			my @prod_Vers = simpleXPathQueryForText($file, 'product/[@name="'. $$prod{'name'} .'"]/version');
                        print ("|");
                        for (my $i = 0; $i < @prod_Vers; $i++)
			{
				print($prod_Vers[$i]);
                                if($i != (@prod_Vers - 1 ))
                                {
                                        print(",");
                                }
			}
			my @build_info = simpleXPathQuery($file, 'product/[@name="'. $$prod{'name'} .'"]/build-info');
                        print ("|");
                        for (my $i = 0; $i < @build_info; $i++)
                        {
                                print ($build_info[$i]{'level'} );
                                if($i != (@build_info - 1 ))
                                {
                                        print(",");
                                }
                        }
                        print ("|");
                        for (my $i = 0; $i < @build_info; $i++)
                        {
                                print ($build_info[$i]{'date'} );
                                if($i != (@build_info - 1 ))
                                {
                                        print(",");
                                }
                        }
		}
                print ("\n");
	}
    }
    else
    {
        print "Cannot open dir $!\n";
    }
}
