#!/usr/local/bin/perl
# 
# $Header: ibm_assoc.pl 30-sep-2005.12:16:42 dkapoor Exp $
#
# ibm_assoc.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      ibm_assoc.pl - association script for IBM websphere
#
#    DESCRIPTION
#       Returns information on targets that the ibm websphere config is related to
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dkapoor     09/30/05 - dkapoor_bug-4641966
#    dkapoor     09/30/05 - Creation
# 
use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;
use File::Spec;

my ($configHome) = @ARGV;

#******************************************
#     Global Variables
#*****************************************


# For the files:
#    %IBMHOME%/config/cells/*/nodes/*/servers/*/resources.xml
# 
# get the JDBC Connection Descriptor URI for the JDBCProviders that use
# the oracle.jdbc.pool.OracleConnectionPoolDataSource.
#
if (!defined $configHome)
{
    print STDERR "em_error=IBM HOME is not defined\n";
    exit;
}

my $cellRootPath = File::Spec->catdir($configHome, "config", "cells");
if (!opendir CELLROOTDIR, $cellRootPath)
{
    print STDERR "em_error=Unable to open the cells directory ${cellRootPath}\n";
    exit;
}

while (my $cellEntry = readdir(CELLROOTDIR))
{
    my $cellNodeDir = File::Spec->catdir($cellRootPath, $cellEntry, "nodes");
    if (-d $cellNodeDir)
    {
        if (!opendir CELLNODEDIR, $cellNodeDir)
        {
            print STDERR "Unable to open the cells/nodes directory for $cellNodeDir\n";
            exit 0;
        }

        while (my $nodesEntry = readdir(CELLNODEDIR))
        {
            my $cellNodeEntryServersDir = File::Spec->catdir($cellNodeDir, $nodesEntry, "servers");
            if (-d $cellNodeEntryServersDir)
            {
                if (!opendir CELLNODESERVERDIR, $cellNodeEntryServersDir)
                {
                    print STDERR "Unable to open Servers directory $cellNodeEntryServersDir\n";
                    exit 0;
                }

                while (my $cellNodeServerEntry = readdir(CELLNODESERVERDIR))
                {
                    if ($cellNodeServerEntry !~ /^nodeAgent$/)
                    {
                        my $cellNodeServerResource = File::Spec->catfile($cellNodeEntryServersDir, 
                                                   $cellNodeServerEntry, 'resources.xml');
                        if (-f $cellNodeServerResource)
                        {
                            my @connectUrl = simpleXPathQuery($cellNodeServerResource, 
                                           'xmi:XMI/resources.jdbc:JDBCProvider[@implementationClassName="oracle.jdbc.pool.OracleConnectionPoolDataSource"]/factories[@xmi:type="resources.jdbc:DataSource"]/propertySet/resourceProperties[@name="URL"]');
                            foreach my $refJDBCdesc (@connectUrl)
                            {
                                printf "em_result=%s|%s|%s|%s\n",
                                               $ecmAssoc::CONNECTS_TO,
                                               "",
                                               $ecmAssoc::ORACLE_DATABASE_TYPE,
                                               lc($refJDBCdesc->{'value'});
                            }
                        }
                    }
                }
                close CELLNODESERVERDIR;
            }
        }
        close CELLNODEDIR;
    }   
}
close CELLDIR;
