package iniparser;

use Exporter;
@ISA         = ('Exporter');
@EXPORT_OK      = ('parse', 'printattribs','getConfigAttribs','getAttribValue','getCommonScriptVal');

#my $grouppat = qr/\[([^\[\]]*?)\]([^\[\]]*?)\[([^\[\]]*)\]/;
my $grouppat = qr/\[([^\[\]]*?)\]([^\[\]]*)/;
my $singlepat = qr/[\s]*([^=]*?)[\s]*=[\s]*(.*?)[\s]*;/;
sub parse
{
	my $thisline = shift(@_);
	my $pos = 0;
	my $grp, $name;
	my %val;
	foreach $grp ($thisline =~m/$grouppat/g)
	{
		$name=trim($name);
		
		if ($pos == 0)
		{
			#print "Name is $grp\n";
			$name = $grp;
		}
		else
		{
			my %attrs = parsegrp($grp);
			$val{$name} = { %attrs };
			$pos = -1;
		}
		$pos++;
	}

	return %val;
}
sub trim($)
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

sub parsegrp
{
	my $thisline = shift(@_);
	my $attrib;
	my $pos = 0;
	my %attributes;
	my $name;
	foreach $attrib ($thisline =~m/$singlepat/g)
	{
		if ($pos == 0)
		{
			$name = $attrib;
			#print "$attrib is ";
		}
		else
		{
			#print "$attrib\n";
			$attributes{$name} = $attrib;
			$name = "";
			$pos = -1;
		}
		$pos++;
	}

	return %attributes;
}

sub printmap
{
	my (%map) = @_;
	print "[";
	foreach (keys(%map)) 
	{ 
		my $val = $map{$_};
		print "$_=";
		print ("$val,"); 
	}
	print "]";
}

sub printattribs
{
	my (%map) = @_;
	foreach (keys(%map))
	{
		my $val = $map{$_};
		print "$_ = [\n";
		printmap(%$val);
		print "\n]\n";
	}
}

sub outputAttributes
{
	my $lines = shift(@_);
	my $configname = shift(@_);
	my @columns = @_;
	my %attribs = parse($lines);
	my $configattrs = $attribs{$configname};
	my %confhash = %$configattrs;
	#iniparser::printattribs(%attribs);
	my $conf;
	if ($#columns > 0)
	{
		print "em_result=";
		for $conf (@columns)
		{
			print "$confhash{$conf}|";
		}
	}
	else
	{
		foreach (keys(%confhash))
		{
			print "$confhash{$_}|";
		}
	}
	print "\n";
}
sub getConfigAttribs
{
	my $lines = shift(@_);
	my $config=shift(@_);
	my %attribs = parse($lines);
	my $configattrs = $attribs{$config};
	my %confhash = %$configattrs;
	return %confhash;
}
sub getAttribValue
{
	my $lines = shift(@_);
        my $config=shift(@_);
	my $attribName=shift(@_);
	#$singlepat = qr/[\s]*([^=]*?)[\s]*=[\s]*(.*?)[\s]/;
        my %attribs = parse($lines);
        my $configattrs = $attribs{$config};
        my %confhash = %$configattrs;
	my $value=$confhash{$attribName};
	$value=trim($value);
        return $value;

}
sub outputAttributesOnly
{
	my $lines = shift(@_);
	#my $configname = shift(@_);
	my @columns = @_;
	my %attribs = parse($lines);

	#iniparser::printattribs(%attribs);
	my $conf;
	if ($#columns > 0)
	{
		print "em_result=";
		for $conf (@columns)
		{
			my @sec_cols = split(/@/, $conf);			
			my $configattrs = $attribs{$sec_cols[0]};
			my %confhash = %$configattrs;
			print "$confhash{$sec_cols[1]}|";
		}
	}
	else
	{
		foreach (keys(%confhash))
		{
			print "$confhash{$_}|";
		}
	}
	print "\n";
}
sub getCommonScriptVal
{
	my $commonFile = shift(@_);
	my $version = shift(@_);
	my $SAROOTDIR;
	my $SADATADIR;
	if ($version=~/^7.8/)
	{
		$SAROOTDIR=trim($ENV{ANA_INSTALL_DIR});	
		$SADATADIR=trim($ENV{SADATADIR});
		if ( (length($SAROOTDIR)!=0) and (length($SADATADIR)!=0))
		{
			return ($SAROOTDIR,$SADATADIR);
		}
	}
	open (COMMONFILE, $commonFile);

	$count = 0;
	while ($record = <COMMONFILE>)
	{
	        my $eqIndex=index($record,"=");
	        my $name = trim(substr($record,0,$eqIndex));
	        my $value = trim(substr($record,$eqIndex+1));
	        if($name eq 'SADATADIR')
	        {
                	#print "$name EQ $value";
        	        $SADATADIR=$value;
	        }
	        if ($name eq 'ANA_INSTALL_DIR')
	        {
        	        $SAROOTDIR=$value;
	        }
	        if ( ($SAROOTDIR ne '') and ($SADATADIR ne '') )
	        {
	                last;
	        }
	        $count++;
	      #print $record;
	   }
	#print "tota l count $count";
	#print "SAROOT $SAROOTDIR";
	#print "SADATA $SADATADIR";
	close(COMMONFILE);
	$SAROOTDIR=trim($SAROOTDIR);
	$SADATADIR=trim($SADATADIR);
	return ($SAROOTDIR,$SADATADIR);

}
return 1;
