#
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#      insecureservices.pl
#
#    DESCRIPTION
#      List of all "insecure" services
#
#    MODIFIED   (MM/DD/YY)
#      dkjain    05/11/05 - 
#      rmadampa  09/03/04 - Mac OS X Porting 
#      hmulling  03/16/04 - replace uname with perl command for windows 
#      hmulling  03/16/04 - replace uname with perl command for windows 
#      mbhoopat  03/10/04 - linux port 
#      hmulling  03/04/04 - change cat to type for windows path 
#      anajmi    09/30/03 - removed ssh from the list
#      hmulling  09/24/03 - add windows nt support
#      leonid eujang   09/04/03 - eujang_esm_init_no_intgr 
#      leonid Nilva  	 07/31/03 - created
#
#
# Summary
#
#	Print out those services which are running from the hard coded list of service names
#
# Implementation
#	
#	1. Go through /etc/services and create a lookup table containing those which are predefined
#	   Lookup table %svclookup : <port number> => <service name>
#	2. Go through netsat -an narrowed for idle or listen and non-localhost
#	   collecting only ports which are keys in the lookup table %svclookup
#	   and filling in another lookup table %insecureservices
#	   Lookup table %insecureservices : <predefined service name> => <port number>
#	3. Print %insecureservices : "em_result=<predefined service name>=<port number>"

$ENV{PATH} = "$ENV{PATH}:/usr/bin:/usr/sbin:/usr/ucb:/bin";

#require "$ENV{EMDROOT}/sysman/admin/scripts/esa_config.pl";
#my $targetType = "host" ;
my $all = $ENV{'IMAXCOUNT'};
my $maxCount;
my $limit = 0 ;
if($all != -1){
  $maxCount = $all;
}

chomp($os = $^O);
if (($os ne "MSWin32") && ($os ne "MSWin64")) 
{
	chomp($os = `uname -s`);
}

#
# Hard coded names of "insecure" services to look for
#
@NAMES = ('rlogin', 'rsh', 'ftp', 'telnet');

# if running on windows then ...
if ($ENV{windir} ne "") 
{
   # the services file is stored in this odd location
   @SERVICES = `type $ENV{windir}\\system32\\drivers\\etc\\services `;
}
else 
{
   @SERVICES = `cat /etc/services `;
}
for $userline (@SERVICES) 
{
#	print "SERVICE: $userline";

						# $userline looks like:
						# printer                515/tcp         ...
	@svcs = split(/[\t\ ]+/, $userline);
	$s0 = $svcs[0];			# service name
	$s1 = $svcs[1];			# port/protocol
	$k = index($s0, "#");			# index of beginng of comment with the name, if any

#	print "SERVICE[0,1,2] : 0=$s0 1=$s1 k=$k\n";

	if ( ($s0 ne "") && ($s1 ne "") && ($k == -1))
	{
		@svc = split(/\//, $s1);		# spliting port/protocol
#		print "$s0 => $svc[0]\n";

		foreach $name (@NAMES)
		{
			if ($name eq $s0)		# name of predefined service equals actual service name from /etc/services
			{
				$svclookup{$svc[0]} = $s0;
#				print "$name => $svclookup{$svc[0]} => $s0 ($svc[0])\n";
			}
		}
	}
}

@NETSTAT = `netstat -an`;
LINE: for $userline (@NETSTAT) 
{
        if (index($userline, "127.0.0.1") >= 0) { next LINE; }

        if (index($userline, "LISTEN") < 0 && index($userline, "IDLE") < 0) { 
                next LINE; 
        }

        # for unix  domain sockets $userline has LISTENING, skip those lines
        if ($os eq "Linux" && index($userline, "LISTENING") >= 0) { 
	    next LINE; 
        }

#	print "NETSTAT: $userline\n";
	@points = split(/[\t\ ]+/, $userline);

	# window windows there is a : in the  line
	if (index($userline, ":") > 0) 
        {
            if ($os eq "Linux") {
	      $p1 = $points[3];
            } else {
	      $p1 = $points[2];  # windows
            }
	    @point = split(/:/, $p1);

	    $p1 = $point[$#point];	# last item within <numeric ip>:<port number>, i.e. port
        } 
        else 
        {
	    if ($os eq "HP-UX" || $os eq "OSF1" || $os eq "AIX" || $os eq "Darwin") {
	        $p1 = $points[3];
            } else {
	        $i = index($userline, " ");
	        if ($i > 0)
	        {
		    $p1 = $points[0];
	        }
	        else
	        {
		    $p1 = $points[1];
	        }
            }
        }
#	print "NETSTAT[1] : $i \"$p1\" of \"$userline\"\n";

	if ($p1 ne "*\.*")
	{
		@point = split(/\.+/, $p1);
		$pl = @point;
		$p = $point[$pl - 1];	# last item within <numeric ip>.<port number>, i.e. port
		$ins = $svclookup{$p};	# try to get name of predefined service by its port 
                                     # from the lookup table
		if ($ins ne "")
		{
			$insecureservices{$ins} = $p;
		}
	}
}

foreach $ins (sort keys (%insecureservices)) 
{
#	print "em_result=$ins=$insecureservices{$ins}\n";

     if($all == -1){
	print "em_result=service=$ins\n";
     }
     else{    
        if($limit >= $maxCount){
          last ;
        }
	print "em_result=service=$ins\n";
        $limit++;
      }
}
