#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/java_virtual_machine.pl /main/2 2012/01/05 19:32:03 nvarma Exp $
#
# java_virtual_machine.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      java_virtual_machine.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvarma      08/18/11 - Creation
# 

use strict;
use hostOSD;

use File::Spec;

use Config;
require "semd_common.pl";
require "find_os.pl";


my $osType = get_osType();
my $sepchar = "/";
my $targetExe = "java";

if ($osType eq "WIN")
{
    $sepchar='\\';
    $targetExe = "java.exe";
}
my $middlewareHome = "";

  EMD_PERL_DEBUG("In java_virtual_machine script.\n");
  $middlewareHome = $ENV{'BEA_HOME'};
  EMD_PERL_DEBUG("BEA_HOME is : $middlewareHome\n");
  if (!defined($middlewareHome))
  {
# Targetting JRockit in a MW home only
    EMD_PERL_DEBUG("No BEA_HOME defined, aborting jrockit discovery\n");
    exit;
  }


my $fl;
my $allFiles;

opendir (MW, "${middlewareHome}");
my @allFiles = readdir(MW);
my @files = grep(/jrockit*/, @allFiles);
  EMD_PERL_DEBUG("@files\n");
closedir(MW);

my $i =-1;
my @jrockitDir;
for my $jDir (@files)
{
  $i = $i+1;
  $jrockitDir[$i] = $files[$i];
  EMD_PERL_DEBUG("JRockit Dir = ${jrockitDir[$i]}\n");
  chomp($jrockitDir[$i]);
   if ($jrockitDir[$i] eq "") 
   {
       EMD_PERL_DEBUG("No jrockit directory\n");
       next;
   }

my $jvm_loc = "${middlewareHome}${sepchar}${jrockitDir[$i]}";
    EMD_PERL_DEBUG("Java Location = $jvm_loc\n");
my $javaExe = "${jvm_loc}${sepchar}jre${sepchar}bin${sepchar}${targetExe}";

	 unless (-e $javaExe)
	 {
	    EMD_PERL_DEBUG("No java executable found \n");
		 next;
	 }

    my $cmd     = "";
   #Calling the JVMInf.java class to get the version and vendor
    $cmd = "$javaExe -classpath ${middlewareHome}/utils/ccr/lib/emocmclnt.jar oracle.sysman.ccr.collector.util.JVMInf";
        EMD_PERL_DEBUG("${cmd} \n");
    my $javaprops = `$cmd`;
    my @values = split("\n", $javaprops);
    my %JVMProps;
    for (my $i = 0; $i < scalar(@values); $i++)
    {
       my ($key, $value) = split("=", $values[$i]);
       $JVMProps{$key} = $value;
    }

    my $javaVendor = $JVMProps{"java.vendor"};  
    my $jvmName = $JVMProps{"java.vm.name"};
    my $jvmVendor = $JVMProps{"java.vm.vendor"};
    my $jvmVersion = $JVMProps{"java.vm.version"};
#    # Need to filter out '|' from all the variables 
    $jvmVersion =~ s/\|//g;
    $jvmVendor =~ s/\|//g;
    $jvmName =~ s/\|//g;
    my $OSNAME = $Config{'osname'};
# Keeping JVM_ID blank for now, reserved for future usage.
   print "em_result=$jvm_loc|$jvmVersion|$jvmVendor|$jvmName|$OSNAME|\n";

} # end of for loop

# End of the Program 


