#!/usr/local/bin/perl
# 
# $Header: rman.pl 03-jul-2002.12:20:41 hying Exp $
#
# rman.pl
# 
# Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      rman.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hying       07/03/02 - catch output
#    hying       07/02/02 - hying_submit_job
#    hying       07/01/02 - Creation
# 
#!/usr/local/bin/perl

require "emd_common.pl";
use File::Temp qw/ tempfile tempdir /;

##
# Set Environment Variables
##
sub set_env_var()
{
  ($ENV{ORACLE_HOME},$ENV{ORACLE_SID}) = @_;
  EMD_PERL_DEBUG("Rman: ORACLE_HOME: $ENV{ORACLE_HOME}");
  EMD_PERL_DEBUG("Rman: ORACLE_SID: $ENV{ORACLE_SID}");
  $ENV{LD_LIBRARY_PATH} = "$ENV{ORACLE_HOME}/lib";
  $ENV{SHLIB_PATH} = "$ENV{ORACLE_HOME}/lib";
  $ENV{LIBPATH} = "$ENV{ORACLE_HOME}/lib";
  $ENV{PATH} = "$ENV{ORACLE_HOME}/bin";
  $ENV{ORA_NLS} = "";
  $ENV{ORA_NLS32} = "";
  $ENV{ORA_NLS33} = "";

}

sub db_status()
{
  my $dir = tempdir(CLEANUP => 1);
  (my $status_fh, my $status_filename) = tempfile( DIR => $dir );
  open(SQL_WRITER, "|$ENV{ORACLE_HOME}/bin/sqlplus /nolog") || die "Can not open pipe for SQLPLUS";
  print SQL_WRITER "connect $db_username/$db_password as SYSDBA\n";
  print SQL_WRITER "select * from v$instance;\n";
  print SQL_WRITER "exit;\n";
  close SQL_WRITER;
  close $status_fh;
}

sub run_rman()
{
  my($db_username, $db_password, $is_cold_backup) = @_;
  my $dir = tempdir(CLEANUP => 1);
  my ($rman_fh, $rman_filename) = tempfile( DIR => $dir );

  open(RMAN_WRITER, "|$ENV{ORACLE_HOME}/bin/rman nocatalog log=$rman_filename")
    || die "Can not open pipe for RMAN";
  print RMAN_WRITER "connect target $db_username/$db_password\n";
  print RMAN_WRITER $rman_script;
  print RMAN_WRITER "exit;\n";
  close RMAN_WRITER;

  open (OUT, "$rman_filename") || die "Unable to open tmp file\n";
  while (<OUT>)
  {
    print;
  }
  close OUT;
  close $log_fh;
}

